/*
    Copyright (c) 2005-2026 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.gdrive;

import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileNameParser;


/**
 * Implementation for Google Drive.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class GDriveFileNameParser extends URLFileNameParser {


    /**
     * The shared parser instance.
     */
    protected static GDriveFileNameParser sharedInstance = null;


    /**
     * Constructor method.
     */
    public GDriveFileNameParser() {
        super(80);  // Port 80 (HTTP port)
    }

    /**
     * Provides the shared instance of the parser.
     *
     * @return Shared instance
     */
    public static synchronized FileNameParser getSharedInstance() {

        if (sharedInstance == null) sharedInstance = new GDriveFileNameParser();
        return sharedInstance;
    }
}
