/*
    Copyright (c) 2005-2025 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.s3;

import com.lf.vfslib.VFSLib;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;

/**
 * Factory for Amazon S3 clients.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class S3ClientFactory {


    /**
     * Constructor method (do not use).
     *
     * @throws InstantiationException Error indication
     * @since 1.6
     */
    public S3ClientFactory() throws InstantiationException {

        if (!java.beans.Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    /**
     * Creates a new connection to the server.
     *
     * @param root        The file system root
     * @param options     The file system options
     * @param credentials The credentials
     * @param vfslib      The parental object, shared instance if <code>null</code>
     * @return The new client
     * @throws org.apache.commons.vfs2.FileSystemException If an error occurs
     * @since 1.6
     */
    public static S3Client createClient(GenericFileName root, FileSystemOptions options,
                                        AwsCredentialsProvider credentials, VFSLib vfslib) throws FileSystemException {

        // See https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/java_s3_code_examples.html

        S3FileSystemConfigBuilder builder = S3FileSystemConfigBuilder.getSharedInstance();
        String awsregion = builder.getAWSRegion(options);

        return S3Client.builder() //
                .credentialsProvider(credentials) //
                .region(Region.of(awsregion)) //
                .build();
    }
}
