/*
    Copyright (c) 2005-2025 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.net;

/**
 * Simple interface for client objects generated for FTP and SFTP connections (clients).
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public interface ClientWrapper {


    /**
     * Let's the underlying client disconnect from the server.
     *
     * @return Successful?
     * @since 1.6
     */
    boolean disconnectClient();

    /**
     * Provides the unique URL identifier used to manage this client instance.
     * <p>
     * Something like "ftp://user@company.com:21".
     *
     * @return Successful?
     * @since 1.6
     */
    String getURLID();
}
