/*
    Copyright (c) 2005-2025 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.dropbox;

import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileNameParser;


/**
 * Implementation for Dropbox.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class DbxFileNameParser extends URLFileNameParser {


    /**
     * The shared parser instance.
     */
    protected static DbxFileNameParser sharedInstance = null;


    /**
     * Constructor method.
     *
     * @since 1.6
     */
    public DbxFileNameParser() {
        super(80);  // Port 80 (HTTP port)
    }

    /**
     * Provides the shared instance of the parser.
     *
     * @return Shared instance
     * @since 1.6
     */
    public static synchronized FileNameParser getSharedInstance() {

        if (sharedInstance == null) sharedInstance = new DbxFileNameParser();
        return sharedInstance;
    }
}
