/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtil {
    public static final int DefaultCopyBufferSize = 16384;
    private static final ThreadLocal<byte[]> slurpBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    public static final InputStream EmptyInputStream = new InputStream(){

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] data) {
            return -1;
        }

        @Override
        public int read(byte[] data, int off, int len) {
            return -1;
        }
    };
    public static final OutputStream BlackHoleOutputStream = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] data) {
        }

        @Override
        public void write(byte[] data, int off, int len) {
        }
    };

    public static void copyStreamToStream(InputStream in, OutputStream out) throws ReadException, WriteException {
        IOUtil.copyStreamToStream(in, out, 16384);
    }

    public static void copyStreamToStream(InputStream in, OutputStream out, byte[] copyBuffer) throws ReadException, WriteException {
        while (true) {
            int count;
            try {
                count = in.read(copyBuffer);
            }
            catch (IOException ex) {
                throw new ReadException(ex);
            }
            if (count == -1) break;
            try {
                out.write(copyBuffer, 0, count);
            }
            catch (IOException ex) {
                throw new WriteException(ex);
            }
        }
    }

    public static void copyStreamToStream(InputStream in, OutputStream out, int copyBufferSize) throws ReadException, WriteException {
        IOUtil.copyStreamToStream(in, out, new byte[copyBufferSize]);
    }

    public static byte[] slurp(InputStream in, int byteLimit) throws IOException {
        if (byteLimit < 0) {
            throw new RuntimeException("'byteLimit' must be non-negative: " + byteLimit);
        }
        byte[] copyBuffer = slurpBuffer.get();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.copyStreamToStream(in, (OutputStream)baos, copyBuffer);
        return baos.toByteArray();
    }

    public void copyFileToStream(File fin, OutputStream out) throws ReadException, WriteException {
        this.copyFileToStream(fin, out, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileToStream(File fin, OutputStream out, int copyBufferSize) throws ReadException, WriteException {
        FileInputStream in;
        try {
            in = new FileInputStream(fin);
        }
        catch (IOException ex) {
            throw new ReadException(ex);
        }
        try {
            IOUtil.copyStreamToStream((InputStream)in, out, copyBufferSize);
        }
        finally {
            IOUtil.closeInput(in);
        }
    }

    public void copyStreamToFile(InputStream in, File fout) throws ReadException, WriteException {
        this.copyStreamToFile(in, fout, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStreamToFile(InputStream in, File fout, int copyBufferSize) throws ReadException, WriteException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(fout);
        }
        catch (IOException ex) {
            throw new WriteException(ex);
        }
        try {
            IOUtil.copyStreamToStream(in, (OutputStream)out, copyBufferSize);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                throw new WriteException(ex);
            }
        }
    }

    public static void closeInput(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeInput(Reader in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class WriteException
    extends WrappedException {
        public static final long serialVersionUID = 0L;

        public WriteException(String message, IOException underlying) {
            super(message, underlying);
        }

        public WriteException(IOException underlying) {
            super(underlying);
        }
    }

    public static final class ReadException
    extends WrappedException {
        public static final long serialVersionUID = 0L;

        public ReadException(String message, IOException underlying) {
            super(message, underlying);
        }

        public ReadException(IOException underlying) {
            super(underlying);
        }
    }

    public static abstract class WrappedException
    extends IOException {
        public static final long serialVersionUID = 0L;
        public final IOException underlying;

        public WrappedException(String message, IOException underlying) {
            super(message + ": " + underlying.getMessage(), underlying);
            this.underlying = underlying;
        }

        public WrappedException(IOException underlying) {
            super(underlying);
            this.underlying = underlying;
        }

        @Override
        public String getMessage() {
            String m = this.underlying.getMessage();
            if (m == null) {
                return "";
            }
            return m;
        }

        @Override
        public IOException getCause() {
            return this.underlying;
        }
    }
}

