/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.DbxWebAuthHelper;
import com.dropbox.core.util.StringUtil;
import java.security.SecureRandom;
import java.util.Map;

public class DbxWebAuth {
    private final DbxRequestConfig requestConfig;
    private final DbxAppInfo appInfo;
    private final String redirectUri;
    private final DbxSessionStore csrfTokenStore;

    public DbxWebAuth(DbxRequestConfig requestConfig, DbxAppInfo appInfo, String redirectUri, DbxSessionStore csrfTokenStore) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("'requestConfig' is null");
        }
        if (appInfo == null) {
            throw new IllegalArgumentException("'appInfo' is null");
        }
        if (redirectUri == null) {
            throw new IllegalArgumentException("'redirectUri' is null");
        }
        if (csrfTokenStore == null) {
            throw new IllegalArgumentException("'csrfTokenStore' is null");
        }
        this.requestConfig = requestConfig;
        this.appInfo = appInfo;
        this.redirectUri = redirectUri;
        this.csrfTokenStore = csrfTokenStore;
    }

    public String start(String urlState) {
        String csrfAscii;
        SecureRandom r = new SecureRandom();
        byte[] csrfRaw = new byte[16];
        r.nextBytes(csrfRaw);
        String state = csrfAscii = StringUtil.urlSafeBase64Encode(csrfRaw);
        if (urlState != null) {
            state = state + "|" + urlState;
        }
        this.csrfTokenStore.set(csrfAscii);
        return DbxWebAuthHelper.getAuthorizeUrl(this.appInfo, this.requestConfig.userLocale, this.redirectUri, state);
    }

    public String start() {
        return this.start(null);
    }

    public DbxAuthFinish finish(Map<String, String[]> queryParams) throws DbxException, BadRequestException, BadStateException, CsrfException, NotApprovedException, ProviderException {
        String givenUrlState;
        String givenCsrfToken;
        if (queryParams == null) {
            throw new IllegalArgumentException("'queryParams' is null");
        }
        String state = DbxWebAuth.getParam(queryParams, "state");
        if (state == null) {
            throw new BadRequestException("missing 'state' parameter");
        }
        String error = DbxWebAuth.getParam(queryParams, "error");
        String code = DbxWebAuth.getParam(queryParams, "code");
        String errorDescription = DbxWebAuth.getParam(queryParams, "error_description");
        if (code == null && error == null) {
            throw new BadRequestException("missing both 'code' and 'error'; one must be present");
        }
        if (code != null && error != null) {
            throw new BadRequestException("both 'code' and 'error' are set; only one must be present");
        }
        if (code != null && errorDescription != null) {
            throw new BadRequestException("both 'code' and 'error_description' are set");
        }
        String csrfTokenFromSession = this.csrfTokenStore.get();
        if (csrfTokenFromSession == null) {
            throw new BadStateException();
        }
        if (csrfTokenFromSession.length() <= 20) {
            throw new AssertionError((Object)("CSRF token too short: " + StringUtil.jq(csrfTokenFromSession)));
        }
        int divPos = state.indexOf(124);
        if (divPos < 0) {
            givenCsrfToken = state;
            givenUrlState = null;
        } else {
            givenCsrfToken = state.substring(0, divPos);
            givenUrlState = state.substring(divPos);
        }
        if (!StringUtil.secureStringEquals(csrfTokenFromSession, givenCsrfToken)) {
            throw new CsrfException("expecting " + StringUtil.jq(csrfTokenFromSession) + ", got " + StringUtil.jq(givenCsrfToken));
        }
        this.csrfTokenStore.clear();
        if (error != null) {
            if (error.equals("access_denied")) {
                String exceptionMessage = errorDescription == null ? "No additional description from Dropbox" : "Additional description from Dropbox: " + errorDescription;
                throw new NotApprovedException(exceptionMessage);
            }
            String exceptionMessage = error;
            if (errorDescription != null) {
                exceptionMessage = exceptionMessage + ": " + errorDescription;
            }
            throw new ProviderException(exceptionMessage);
        }
        assert (code != null);
        DbxAuthFinish finish = DbxWebAuthHelper.finish(this.appInfo, this.requestConfig, code, this.redirectUri);
        return new DbxAuthFinish(finish.accessToken, finish.userId, givenUrlState);
    }

    private static String getParam(Map<String, String[]> params, String name) throws BadRequestException {
        String[] v = params.get(name);
        if (v == null) {
            return null;
        }
        assert (v.length != 0);
        if (v.length == 1) {
            return v[0];
        }
        throw new BadRequestException("multiple occurrences of '" + name + "' parameter");
    }

    public static final class ProviderException
    extends Exception {
        public ProviderException(String message) {
            super(message);
        }
    }

    public static final class NotApprovedException
    extends Exception {
        public NotApprovedException(String message) {
            super(message);
        }
    }

    public static final class CsrfException
    extends Exception {
        public CsrfException(String message) {
            super(message);
        }
    }

    public static final class BadStateException
    extends Exception {
        public BadStateException() {
            super("Not expecting Dropbox auth redirect (session doesn't have CSRF token)");
        }
    }

    public static final class BadRequestException
    extends Exception {
        public BadRequestException(String message) {
            super(message);
        }
    }

    public static abstract class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }
    }
}

