/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxPath;
import com.dropbox.core.json.JsonArrayReader;
import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Collector;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public abstract class DbxEntry
extends Dumpable
implements Serializable {
    public static final long serialVersionUID = 0L;
    public final String name;
    public final String path;
    public final String iconName;
    public final boolean mightHaveThumbnail;
    public static final JsonReader<DbxEntry> Reader = new JsonReader<DbxEntry>(){

        @Override
        public final DbxEntry read(JsonParser parser) throws IOException, JsonReadException {
            return DbxEntry.read((JsonParser)parser, null).entry;
        }
    };
    private static final int FM_size = 0;
    private static final int FM_bytes = 1;
    private static final int FM_path = 2;
    private static final int FM_is_dir = 3;
    private static final int FM_is_deleted = 4;
    private static final int FM_rev = 5;
    private static final int FM_thumb_exists = 6;
    private static final int FM_icon = 7;
    private static final int FM_modified = 8;
    private static final int FM_client_mtime = 9;
    private static final int FM_hash = 10;
    private static final int FM_contents = 11;
    private static final JsonReader.FieldMapping FM;

    private DbxEntry(String path, String iconName, boolean mightHaveThumbnail) {
        this.name = DbxPath.getName(path);
        this.path = path;
        this.iconName = iconName;
        this.mightHaveThumbnail = mightHaveThumbnail;
    }

    @Override
    protected void dumpFields(DumpWriter w) {
        w.value(this.path);
        w.field("iconName", this.iconName);
        w.field("mightHaveThumbnail", this.mightHaveThumbnail);
    }

    public abstract boolean isFolder();

    public abstract boolean isFile();

    public abstract Folder asFolder();

    public abstract File asFile();

    protected boolean partialEquals(DbxEntry o) {
        if (!this.name.equals(o.name)) {
            return false;
        }
        if (!this.path.equals(o.path)) {
            return false;
        }
        if (!this.iconName.equals(o.iconName)) {
            return false;
        }
        return this.mightHaveThumbnail == o.mightHaveThumbnail;
    }

    public static <C> WithChildrenC<C> read(JsonParser parser, Collector<DbxEntry, ? extends C> collector) throws IOException, JsonReadException {
        DbxEntry e;
        JsonLocation top = JsonReader.expectObjectStart(parser);
        String size = null;
        long bytes = -1L;
        String path = null;
        Boolean is_dir = null;
        Boolean is_deleted = null;
        String rev = null;
        Boolean thumb_exists = null;
        String icon = null;
        Date modified = null;
        Date client_mtime = null;
        String hash = null;
        Object contents = null;
        while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            JsonReader.nextToken(parser);
            int fi = FM.get(fieldName);
            try {
                switch (fi) {
                    case -1: {
                        JsonReader.skipValue(parser);
                        break;
                    }
                    case 0: {
                        size = JsonReader.StringReader.readField(parser, fieldName, size);
                        break;
                    }
                    case 1: {
                        bytes = JsonReader.readUnsignedLongField(parser, fieldName, bytes);
                        break;
                    }
                    case 2: {
                        path = JsonReader.StringReader.readField(parser, fieldName, path);
                        break;
                    }
                    case 3: {
                        is_dir = JsonReader.BooleanReader.readField(parser, fieldName, is_dir);
                        break;
                    }
                    case 4: {
                        is_deleted = JsonReader.BooleanReader.readField(parser, fieldName, is_deleted);
                        break;
                    }
                    case 5: {
                        rev = JsonReader.StringReader.readField(parser, fieldName, rev);
                        break;
                    }
                    case 6: {
                        thumb_exists = JsonReader.BooleanReader.readField(parser, fieldName, thumb_exists);
                        break;
                    }
                    case 7: {
                        icon = JsonReader.StringReader.readField(parser, fieldName, icon);
                        break;
                    }
                    case 8: {
                        modified = JsonDateReader.Dropbox.readField(parser, fieldName, modified);
                        break;
                    }
                    case 9: {
                        client_mtime = JsonDateReader.Dropbox.readField(parser, fieldName, client_mtime);
                        break;
                    }
                    case 10: {
                        if (collector == null) {
                            throw new JsonReadException("not expecting \"hash\" field, since we didn't ask for children", parser.getCurrentLocation());
                        }
                        hash = JsonReader.StringReader.readField(parser, fieldName, hash);
                        break;
                    }
                    case 11: {
                        if (collector == null) {
                            throw new JsonReadException("not expecting \"contents\" field, since we didn't ask for children", parser.getCurrentLocation());
                        }
                        contents = JsonArrayReader.mk(Reader, collector).readField(parser, fieldName, (DbxEntry)contents);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("bad index: " + fi + ", field = \"" + fieldName + "\""));
                    }
                }
            }
            catch (JsonReadException ex) {
                throw ex.addFieldContext(fieldName);
            }
        }
        JsonReader.expectObjectEnd(parser);
        if (path == null) {
            throw new JsonReadException("missing field \"path\"", top);
        }
        if (icon == null) {
            throw new JsonReadException("missing field \"icon\"", top);
        }
        if (is_deleted == null) {
            is_deleted = Boolean.FALSE;
        }
        if (is_dir == null) {
            is_dir = Boolean.FALSE;
        }
        if (thumb_exists == null) {
            thumb_exists = Boolean.FALSE;
        }
        if (is_dir.booleanValue() && (contents != null || hash != null)) {
            if (hash == null) {
                throw new JsonReadException("missing \"hash\", when we asked for children", top);
            }
            if (contents == null) {
                throw new JsonReadException("missing \"contents\", when we asked for children", top);
            }
        }
        if (is_dir.booleanValue()) {
            e = new Folder(path, icon, thumb_exists);
        } else {
            if (size == null) {
                throw new JsonReadException("missing \"size\" for a file entry", top);
            }
            if (bytes == -1L) {
                throw new JsonReadException("missing \"bytes\" for a file entry", top);
            }
            if (modified == null) {
                throw new JsonReadException("missing \"modified\" for a file entry", top);
            }
            if (client_mtime == null) {
                throw new JsonReadException("missing \"client_mtime\" for a file entry", top);
            }
            if (rev == null) {
                throw new JsonReadException("missing \"rev\" for a file entry", top);
            }
            e = new File(path, icon, thumb_exists, bytes, size, modified, client_mtime, rev);
        }
        if (is_deleted.booleanValue()) {
            return null;
        }
        return new WithChildrenC<Object>(e, hash, contents);
    }

    static {
        JsonReader.FieldMapping.Builder b = new JsonReader.FieldMapping.Builder();
        b.add("size", 0);
        b.add("bytes", 1);
        b.add("path", 2);
        b.add("is_dir", 3);
        b.add("is_deleted", 4);
        b.add("rev", 5);
        b.add("thumb_exists", 6);
        b.add("icon", 7);
        b.add("modified", 8);
        b.add("client_mtime", 9);
        b.add("hash", 10);
        b.add("contents", 11);
        FM = b.build();
    }

    public static final class WithChildrenC<C>
    implements Serializable {
        public static final long serialVersionUID = 0L;
        public final DbxEntry entry;
        public final String hash;
        public final C children;

        public WithChildrenC(DbxEntry entry, String hash, C children) {
            this.entry = entry;
            this.hash = hash;
            this.children = children;
        }

        public static class Reader<C>
        extends JsonReader<WithChildrenC<C>> {
            private final Collector<DbxEntry, ? extends C> collector;

            public Reader(Collector<DbxEntry, ? extends C> collector) {
                this.collector = collector;
            }

            @Override
            public final WithChildrenC<C> read(JsonParser parser) throws IOException, JsonReadException {
                return DbxEntry.read(parser, this.collector);
            }
        }
    }

    public static final class WithChildren
    implements Serializable {
        public static final long serialVersionUID = 0L;
        public final DbxEntry entry;
        public final String hash;
        public final List<DbxEntry> children;
        public static final JsonReader<WithChildren> Reader = new JsonReader<WithChildren>(){

            @Override
            public final WithChildren read(JsonParser parser) throws IOException, JsonReadException {
                WithChildrenC c = DbxEntry.read(parser, new Collector.ArrayListCollector());
                return new WithChildren(c.entry, c.hash, (List)c.children);
            }
        };

        public WithChildren(DbxEntry entry, String hash, List<DbxEntry> children) {
            this.entry = entry;
            this.hash = hash;
            this.children = children;
        }
    }

    public static final class File
    extends DbxEntry {
        public static final long serialVersionUID = 0L;
        public final long numBytes;
        public final String humanSize;
        public final Date lastModified;
        public final Date clientMtime;
        public final String rev;
        public static final JsonReader<File> Reader = new JsonReader<File>(){

            @Override
            public final File read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = parser.getCurrentLocation();
                DbxEntry e = DbxEntry.read((JsonParser)parser, null).entry;
                if (!(e instanceof File)) {
                    throw new JsonReadException("Expecting a file entry, got a folder entry", top);
                }
                return (File)e;
            }
        };

        public File(String path, String iconName, boolean mightHaveThumbnail, long numBytes, String humanSize, Date lastModified, Date clientMtime, String rev) {
            super(path, iconName, mightHaveThumbnail);
            this.numBytes = numBytes;
            this.humanSize = humanSize;
            this.lastModified = lastModified;
            this.clientMtime = clientMtime;
            this.rev = rev;
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            super.dumpFields(w);
            w.field("numBytes", this.numBytes);
            w.field("humanSize", this.humanSize);
            w.field("lastModified", this.lastModified);
            w.field("clientMtime", this.clientMtime);
            w.field("rev", this.rev);
        }

        @Override
        protected String getTypeName() {
            return "File";
        }

        @Override
        public boolean isFolder() {
            return false;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public Folder asFolder() {
            throw new RuntimeException("not a folder");
        }

        @Override
        public File asFile() {
            return this;
        }

        public boolean equals(Object o) {
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.equals((File)o);
        }

        public boolean equals(File o) {
            if (!this.partialEquals(o)) {
                return false;
            }
            if (this.numBytes != o.numBytes) {
                return false;
            }
            if (!this.humanSize.equals(o.humanSize)) {
                return false;
            }
            if (!this.lastModified.equals(o.lastModified)) {
                return false;
            }
            if (!this.clientMtime.equals(o.clientMtime)) {
                return false;
            }
            return this.rev.equals(o.rev);
        }
    }

    public static final class Folder
    extends DbxEntry {
        public static final long serialVersionUID = 0L;
        public static final JsonReader<Folder> Reader = new JsonReader<Folder>(){

            @Override
            public final Folder read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = parser.getCurrentLocation();
                DbxEntry e = DbxEntry.read((JsonParser)parser, null).entry;
                if (!(e instanceof Folder)) {
                    throw new JsonReadException("Expecting a file entry, got a folder entry", top);
                }
                return (Folder)e;
            }
        };

        public Folder(String path, String iconName, boolean mightHaveThumbnail) {
            super(path, iconName, mightHaveThumbnail);
        }

        @Override
        protected String getTypeName() {
            return "Folder";
        }

        @Override
        public boolean isFolder() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public Folder asFolder() {
            return this;
        }

        @Override
        public File asFile() {
            throw new RuntimeException("not a file");
        }

        public boolean equals(Object o) {
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.equals((Folder)o);
        }
    }
}

