/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.net;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Localize;
import com.lf.commons.io.FileTypeFactory;
import com.lf.commons.io.IOUtils;
import com.lf.commons.io.TypeProvider;
import com.lf.commons.lang.JavaUtils;
import com.lf.commons.lang.ReflectionUtils;
import com.lf.commons.msg.MessageCodes;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.net.VFSConnection;
import com.lf.vfslib.net.VFSFileSystemManager;
import com.lf.vfslib.net.VFSURI;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;

public final class VFSUtils {
    @Localize(value={@Localize.Variable(name="FILE", value="File"), @Localize.Variable(name="DIRECTORY", value="Directory"), @Localize.Variable(name="CAPA_APPEND_CONTENT", value="File content can be appended"), @Localize.Variable(name="CAPA_ATTRIBUTES", value="File attributes are supported"), @Localize.Variable(name="CAPA_COMPRESS", value="A compressed filesystem is a filesystem which use compression"), @Localize.Variable(name="CAPA_CREATE", value="Files can be created"), @Localize.Variable(name="CAPA_DELETE", value="Files can be deleted"), @Localize.Variable(name="CAPA_DIRECTORY_READ_CONTENT", value="Provides directories which allows you to read its content through a stream"), @Localize.Variable(name="CAPA_DISPATCHER", value="The provider itself do not provide a filesystem"), @Localize.Variable(name="CAPA_FS_ATTRIBUTES", value="File system attributes are supported"), @Localize.Variable(name="CAPA_GET_LAST_MODIFIED", value="File get last-modified time is supported"), @Localize.Variable(name="CAPA_GET_TYPE", value="The file type can be determined"), @Localize.Variable(name="CAPA_JUNCTIONS", value="Junctions are supported"), @Localize.Variable(name="CAPA_LAST_MODIFIED", value="File last-modified time is supported"), @Localize.Variable(name="CAPA_LIST_CHILDREN", value="Children of files can be listed"), @Localize.Variable(name="CAPA_MANIFEST_ATTRIBUTES", value="The set of attributes defined by the Jar manifest specification are supported"), @Localize.Variable(name="CAPA_RANDOM_ACCESS_READ", value="File content can be read in random mode"), @Localize.Variable(name="CAPA_RANDOM_ACCESS_WRITE", value="File content can be written in random mode"), @Localize.Variable(name="CAPA_READ_CONTENT", value="File content can be read"), @Localize.Variable(name="CAPA_RENAME", value="Files can be renamed"), @Localize.Variable(name="CAPA_SET_LAST_MODIFIED_FILE", value="File set last-modified time is supported"), @Localize.Variable(name="CAPA_SET_LAST_MODIFIED_FOLDER", value="Folder set last-modified time is supported"), @Localize.Variable(name="CAPA_SIGNING", value="File content signing is supported"), @Localize.Variable(name="CAPA_URI", value="URI are supported"), @Localize.Variable(name="CAPA_VIRTUAL", value="A virtual filesystem can be an archive like tar or zip"), @Localize.Variable(name="CAPA_WRITE_CONTENT", value="File content can be written")})
    public VFSUtils() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public static Long getLength(FileObject url) {
        try {
            return url.getContent().getSize();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long getLength(FileObject url, long fallback) {
        try {
            return url.getContent().getSize();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Long lastModified(FileObject url) {
        try {
            return url.getContent().getLastModifiedTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long lastModified(FileObject url, long fallback) {
        try {
            return url.getContent().getLastModifiedTime();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static void setLastModified(FileObject url, long timestamp) {
        try {
            url.getContent().setLastModifiedTime(timestamp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Boolean isDirectory(FileObject url) {
        try {
            return !url.getType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isDirectory(FileObject url, boolean fallback) {
        try {
            return !url.getType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static boolean isDirectory(VFSURI vfsuri, boolean fallback) {
        try {
            return !vfsuri.getFileType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Boolean isFile(FileObject url) {
        try {
            return url.getType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isFile(FileObject url, boolean fallback) {
        try {
            return url.getType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static boolean isFile(VFSURI vfsuri, boolean fallback) {
        try {
            return vfsuri.getFileType().equals((Object)FileType.FILE);
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Boolean exists(FileObject url) {
        try {
            return url.exists();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean exists(FileObject url, boolean fallback) {
        try {
            return url.exists();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Boolean canRead(FileObject url) {
        try {
            return url.isReadable();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean canRead(FileObject url, boolean fallback) {
        try {
            return url.isReadable();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Boolean canWrite(FileObject url) {
        try {
            return url.isWriteable();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean canWrite(FileObject url, boolean fallback) {
        try {
            return url.isWriteable();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static Boolean hasCapability(FileObject url, Capability capability) {
        try {
            return url.getFileSystem().hasCapability(capability);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasCapability(FileObject url, Capability capability, boolean fallback) {
        try {
            return url.getFileSystem().hasCapability(capability);
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static FileObject getParent(FileObject url) {
        try {
            return url.getParent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FileObject getRelativeFileURL(FileSystemManager vfsmanager, FileObject parenturl, String relpath) {
        try {
            FileObject reltarget;
            String path = parenturl.toString() + (parenturl.toString().endsWith("/") ? "" : Character.valueOf('/')) + relpath;
            if (vfsmanager == null) {
                vfsmanager = VFSLibSettings.getManagerNetwork();
            }
            if ((reltarget = vfsmanager.resolveFile(path)).exists() && reltarget.getType().equals((Object)FileType.FILE)) {
                return reltarget;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static File getDownloadFile(File directory, FileObject url) {
        try {
            return new File(directory.getAbsoluteFile() + File.separator + url.getName().getBaseName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InputStream openCachedURL(FileObject url, Hashtable<FileObject, byte[]> urlcache, long maxsize) {
        try {
            if (urlcache == null) {
                return url.getContent().getInputStream();
            }
            byte[] data = urlcache.get(url);
            if (data != null) {
                ByteArrayInputStream istream = new ByteArrayInputStream(data);
                CommonsSettings.log(Level.CONFIG, "Recycled URL data for " + url);
                return istream;
            }
            if (url.getContent().getSize() <= maxsize) {
                data = IOUtils.readData(url);
                urlcache.put(url, data);
                return new ByteArrayInputStream(data);
            }
            return url.getContent().getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FileObject getURL(FileSystemManager vfsmanager, String url) {
        try {
            if (vfsmanager == null) {
                vfsmanager = VFSLibSettings.getManagerNetwork();
            }
            return vfsmanager.resolveFile(url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FileObject getURL(VFSFileSystemManager vfsmanager, String url, VFSConnection vfsconn) {
        try {
            if (vfsmanager == null) {
                vfsmanager = VFSLibSettings.getManagerNetwork();
            }
            return vfsmanager.resolveFile(url, vfsconn);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Icon getURLIcon(FileObject url, TypeProvider provider) {
        try {
            Hashtable<String, Object> values = provider.getInfo(url);
            return (Icon)values.get("KEY_ICON");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Icon getURLIcon(VFSURI vfsuri, TypeProvider provider) {
        try {
            Hashtable<String, Object> values = provider.getInfo(vfsuri);
            return (Icon)values.get("KEY_ICON");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getURLType(FileObject url, TypeProvider provider) {
        try {
            Hashtable<String, Object> values = provider.getInfo(url);
            return (String)values.get("KEY_TYPE_DESCRIPTION");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean available(FileObject url) {
        try {
            return url.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isChildOf(FileObject url, FileObject parent) {
        try {
            for (FileObject nextparent = url.getParent(); nextparent != null; nextparent = nextparent.getParent()) {
                if (!nextparent.equals(parent)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isChildOf(VFSURI url, VFSURI parent) {
        try {
            VFSURI nextparent = VFSUtils.getParent(url);
            while (nextparent != null) {
                if (nextparent.equals(parent)) {
                    return true;
                }
                nextparent = VFSUtils.getParent(nextparent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static VFSURI getParent(VFSURI child) {
        try {
            String[] parts = child.getPath().split("[/\\\\]");
            if (parts.length >= 2) {
                StringBuilder builder = new StringBuilder(0);
                for (int i = 0; i < parts.length - 1; ++i) {
                    builder.append(parts[i]);
                    builder.append('/');
                }
                return new VFSURI(child.getScheme(), child.getUserInfo(), child.getHost(), child.getPort(), builder.toString(), child.getQuery(), child.getFragment());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static FileObject getDummyURL() {
        return VFSUtils.getDummyURL(null);
    }

    public static FileObject getDummyURL(String name) {
        VFSFileSystemManager vfsmanager = CommonsSettings.getManagerClasspath();
        try {
            String url = System.getProperty("user.home");
            if (name != null && !name.isEmpty()) {
                url = url + '/' + name;
            }
            return vfsmanager.resolveFile(url);
        }
        catch (Exception e) {
            CommonsSettings settings = CommonsSettings.getSharedInstance();
            MessageCodes mcodes = settings.getMessageCodes();
            String message = mcodes.getMessage("COMMONS-0024", settings.getLogLocale(), true);
            settings.getLogger().log(Level.WARNING, "[commons] " + message);
            return null;
        }
    }

    public static String getRWX(FileObject url) {
        return String.valueOf(VFSUtils.canRead(url, false) ? (char)'r' : '-') + (VFSUtils.canWrite(url, false) ? (char)'w' : '-') + 'x';
    }

    public static String getDRWX(FileObject url) {
        return String.valueOf(VFSUtils.isDirectory(url, false) ? (char)'d' : '-') + VFSUtils.getRWX(url);
    }

    public static String getEntryType(FileObject url, FileTypeFactory typefactory) {
        if (!VFSUtils.exists(url, false)) {
            return "";
        }
        String desc = null;
        if (typefactory != null) {
            try {
                Hashtable<String, Object> values = VFSUtils.isDirectory(url, false) ? typefactory.getInfo(typefactory.getTemporaryDirectory()) : typefactory.getInfo(url);
                desc = (String)values.get("KEY_TYPE_DESCRIPTION");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (desc == null || desc.trim().length() == 0) {
            desc = VFSUtils.isFile(url, false) ? CommonsSettings.getUserText(VFSUtils.class, "FILE") : (VFSUtils.isDirectory(url, false) ? CommonsSettings.getUserText(VFSUtils.class, "DIRECTORY") : "");
        }
        return desc;
    }

    public static String getDisplayBaseName(FileObject url, VFSConnection vfsconn) {
        try {
            String name = url.getName().getBaseName();
            return name;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public static String getDisplayPath(FileObject url, VFSConnection vfsconn) {
        try {
            String name = url.getName().getPath();
            return name;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public static String getDisplayURIObfuscated(FileObject url, VFSConnection vfsconn) {
        try {
            String name = url.getName().getFriendlyURI();
            return name;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public static String getDisplayURIUsernameOnly(FileObject entry, VFSConnection vfsconn) {
        return VFSUtils.getDisplayURIUsernameOnly(String.valueOf(entry), vfsconn);
    }

    public static String getDisplayURIUsernameOnly(VFSURI entry, VFSConnection vfsconn) {
        return VFSUtils.getDisplayURIUsernameOnly(String.valueOf(entry), vfsconn);
    }

    public static String getDisplayURIUsernameOnly(String url, VFSConnection vfsconn) {
        try {
            String name = url;
            String scheme = new VFSURI(url).getScheme();
            name = name.replaceFirst("(^" + scheme + "://)([^:]+)(:[^@]+)(@.*$)", "$1$2$4");
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonsSettings.log(Level.WARNING, "Malformed URL " + url);
            return "null";
        }
    }

    public static String getDisplayURIWithoutCredentials(FileObject url, VFSConnection vfsconn) {
        try {
            return VFSUtils.getDisplayURIWithoutCredentials(String.valueOf(url), url.getName().getScheme(), vfsconn);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public static String getDisplayURIWithoutCredentials(VFSURI vfsuri, VFSConnection vfsconn) {
        try {
            return VFSUtils.getDisplayURIWithoutCredentials(String.valueOf(vfsuri), vfsuri.getScheme(), vfsconn);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    private static String getDisplayURIWithoutCredentials(String path, String scheme, VFSConnection vfsconn) {
        try {
            path = path.replaceFirst("(^" + scheme + "://)([^:]+)(:[^@]+@)(.*$)", "$1$4");
            return path;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public static String debugPrintFileName(FileObject url) {
        StringBuilder builder = new StringBuilder(0);
        FileName name = url.getName();
        try {
            builder.append("Base name:    " + name.getBaseName() + '\n');
            builder.append("Depth:        " + name.getDepth() + '\n');
            builder.append("Extension:    " + name.getExtension() + '\n');
            builder.append("Friendly URL: " + name.getFriendlyURI() + '\n');
            builder.append("Path:         " + name.getPath() + '\n');
            builder.append("Path decoded: " + name.getPathDecoded() + '\n');
            builder.append("Parent:       " + name.getParent() + '\n');
            builder.append("Root:         " + name.getRoot() + '\n');
            builder.append("Root URI:     " + name.getRootURI() + '\n');
            builder.append("Scheme:       " + name.getScheme() + '\n');
            builder.append("Type:         " + name.getType() + '\n');
            builder.append("URI :         " + name.getURI() + '\n');
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.toString();
    }

    public static boolean isParentOf(FileObject url, FileObject child) {
        try {
            for (FileObject nextparent = child.getParent(); nextparent != null; nextparent = nextparent.getParent()) {
                if (!nextparent.equals(url)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Vector<FileObject> getParents(FileObject url) {
        Vector<FileObject> parents = new Vector<FileObject>(0);
        try {
            for (FileObject nextparent = url.getParent(); nextparent != null; nextparent = nextparent.getParent()) {
                parents.addElement(nextparent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parents;
    }

    public static String getCapabilityDescription(Capability capa) {
        try {
            return CommonsSettings.getUserText(VFSUtils.class, "CAPA_" + String.valueOf(capa));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FileObject[] getChildren(FileObject directory) throws FileSystemException {
        if (SwingUtilities.isEventDispatchThread()) {
            CommonsSettings.log(Level.WARNING, "Unsafe: Do not call getChildren() from the EDT (may block the GUI)!");
            Thread.dumpStack();
        }
        return directory.getChildren();
    }

    public static FileObject[] getChildren(FileObject directory, FileObject[] fallback) {
        try {
            return directory.getChildren();
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public static boolean isRoot(FileObject url) {
        return VFSUtils.isDirectory(url, false) && VFSUtils.getParent(url) == null;
    }

    public static void clearDirectory(final FileObject target) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    VFSUtils.clearDirectory(target);
                }
            }, "[commons] VFS Utils Cleaner").start();
            return;
        }
        Vector<FileObject> entries = new Vector<FileObject>(0);
        VFSUtils.collectEntries(target, entries);
        int size = entries.size();
        for (int i = size - 1; i >= 0; --i) {
            try {
                entries.elementAt(i).delete();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        entries.removeAllElements();
    }

    public static void collectEntries(FileObject searchdir, Vector<FileObject> entries) {
        if (searchdir == null || entries == null) {
            return;
        }
        if (!VFSUtils.isDirectory(searchdir, false)) {
            return;
        }
        try {
            FileObject[] urls = VFSUtils.getChildren(searchdir);
            for (int i = 0; i < urls.length; ++i) {
                entries.addElement(urls[i]);
                if (!VFSUtils.isDirectory(urls[i], false)) continue;
                VFSUtils.collectEntries(urls[i], entries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isExistingFile(FileObject url) {
        return VFSUtils.exists(url, false) && VFSUtils.isFile(url, false);
    }

    public static boolean writeFile(FileObject url, InputStream istream) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            OutputStream ostream = url.getContent().getOutputStream();
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
            try {
                ostream.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            ostream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean contains(Vector<FileObject> container, FileObject url) {
        try {
            for (FileObject next : container) {
                if (!String.valueOf(next).equals(String.valueOf(url))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean delete(FileObject target) {
        if (target == null) {
            throw new NullPointerException();
        }
        try {
            return target.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean moveToArchive(FileObject source, String subfolder) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (subfolder == null) {
            subfolder = "ARCHIVE";
        }
        try {
            String path = source.getParent().toString() + '/' + subfolder + '/' + source.getName().getBaseName();
            VFSFileSystemManager vfsmanager = VFSLibSettings.getManagerNetwork();
            FileObject target = vfsmanager.resolveFile(path);
            if (target.exists()) {
                CommonsSettings.log(Level.CONFIG, "moveToArchive(): target=" + VFSUtils.getDisplayURIUsernameOnly(target, null) + " exists (not overwritten)");
            } else {
                CommonsSettings.log(Level.CONFIG, "moveToArchive(): target=" + VFSUtils.getDisplayURIUsernameOnly(target, null));
                if (!target.exists()) {
                    target.createFile();
                }
                if (!target.exists()) {
                    return false;
                }
                CommonsSettings.log(Level.CONFIG, "moveToArchive(): move " + VFSUtils.getDisplayURIUsernameOnly(source, null) + " to " + VFSUtils.getDisplayURIUsernameOnly(target, null));
                source.moveTo(target);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasFileSystemOptions(FileSystemOptions options) {
        try {
            Map map = (Map)ReflectionUtils.getDeclaredField(options, "options");
            return !map.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String debugPrint(FileSystemOptions options) {
        StringBuilder builder = new StringBuilder(0);
        try {
            Map map = (Map)ReflectionUtils.getDeclaredField(options, "options");
            String clazz = options.getClass().getName();
            builder.append("\nTotal variable count (" + clazz + "): " + map.size() + "\n\n");
            Vector collect = new Vector(0);
            for (Object key : map.keySet()) {
                collect.addElement(key);
            }
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        String name1 = (String)ReflectionUtils.getDeclaredField(o1, "name");
                        String name2 = (String)ReflectionUtils.getDeclaredField(o2, "name");
                        return name1.compareTo(name2);
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            };
            Collections.sort(collect, comparator);
            int size = collect.size();
            for (int i = 0; i < size; ++i) {
                Object key = collect.elementAt(i);
                String name = (String)ReflectionUtils.getDeclaredField(key, "name");
                Object value = map.get(key);
                builder.append(name + '=' + value + '\n');
            }
            collect.removeAllElements();
            builder.append('\n');
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.toString();
    }

    public static VFSConnection findVFSConnection(VFSFileSystemManager vfsmanager, String id) {
        for (VFSConnection vfsconn : vfsmanager.getConnections()) {
            if (!vfsconn.getID("").equals(id)) continue;
            return vfsconn;
        }
        return null;
    }

    public static VFSConnection[] findVFSConnections(VFSFileSystemManager vfsmanager, FileObject entry) {
        VFSConnection[] vfsconns = new VFSConnection[]{};
        Vector<VFSConnection> connections = vfsmanager.getConnections();
        for (VFSConnection vfsconn : connections) {
            if (!vfsconn.isAvailable() || !vfsconn.isApplicable(String.valueOf(entry), true)) continue;
            vfsconns = (VFSConnection[])JavaUtils.addToArray(vfsconns, vfsconn);
        }
        for (VFSConnection vfsconn : connections) {
            if (!vfsconn.isAvailable() || !vfsconn.isApplicable(String.valueOf(entry), false) || JavaUtils.elementOf(vfsconn, vfsconns)) continue;
            vfsconns = (VFSConnection[])JavaUtils.addToArray(vfsconns, vfsconn);
        }
        return vfsconns;
    }

    public static VFSConnection[] findVFSConnections(VFSFileSystemManager vfsmanager, String url) {
        VFSConnection[] vfsconns = new VFSConnection[]{};
        Vector<VFSConnection> connections = vfsmanager.getConnections();
        for (VFSConnection vfsconn : connections) {
            if (!vfsconn.isAvailable() || !vfsconn.isApplicable(url, true)) continue;
            vfsconns = (VFSConnection[])JavaUtils.addToArray(vfsconns, vfsconn);
        }
        for (VFSConnection vfsconn : connections) {
            if (!vfsconn.isAvailable() || !vfsconn.isApplicable(url, false) || JavaUtils.elementOf(vfsconn, vfsconns)) continue;
            vfsconns = (VFSConnection[])JavaUtils.addToArray(vfsconns, vfsconn);
        }
        return vfsconns;
    }

    public static String addMissingCredentials(String uri, VFSConnection vfsconn) {
        if (vfsconn != null) {
            try {
                VFSURI uriobj;
                String uriuser;
                String connuser = vfsconn.getUser(null);
                String connpwd = vfsconn.getPassword(null);
                if (connuser != null && connuser.length() >= 1 && connpwd != null && connpwd.length() >= 1 && ((uriuser = (uriobj = new VFSURI(uri)).getUserInfo()) == null || uriuser.isEmpty() || uriuser.indexOf(58) == -1)) {
                    uriobj = new VFSURI(uriobj.getScheme(), connuser + ':' + connpwd, uriobj.getHost(), uriobj.getPort(), uriobj.getPath(), uriobj.getQuery(), uriobj.getFragment());
                    return String.valueOf(uriobj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    public static boolean isSameServer(FileObject url1, FileObject url2) {
        try {
            VFSURI temp = new VFSURI(url1.toString());
            String raw1 = new VFSURI(temp.getScheme(), null, temp.getHost(), temp.getPort(), null, null, null).toString();
            temp = new VFSURI(url2.toString());
            String raw2 = new VFSURI(temp.getScheme(), null, temp.getHost(), temp.getPort(), null, null, null).toString();
            return raw1.equals(raw2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isStateful(String protocol) {
        return protocol.equals("ftp") || protocol.equals("ftps") || protocol.equals("sftp") || protocol.equals("webdav") || protocol.equals(VFSLib.getSharedInstance().getSchemeDropbox());
    }

    public static String getProtocol(String uri) {
        try {
            return new VFSURI(uri).getScheme();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getDefaultPort(String protocol) {
        if (protocol.equals("ftp")) {
            return 21;
        }
        if (protocol.equals("ftps")) {
            return 21;
        }
        if (protocol.equals("http") || protocol.equals("webdav")) {
            return 80;
        }
        if (protocol.equals("https")) {
            return 443;
        }
        if (protocol.equals("sftp")) {
            return 22;
        }
        return -1;
    }
}

