/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.net;

import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.lang.ReflectionUtils;
import com.lf.commons.model.ApplicationModel;
import com.lf.vfslib.net.VFSConnection;
import com.lf.vfslib.net.VFSURI;
import com.lf.vfslib.net.VFSUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.smb.SmbFileProvider;

public class VFSFileSystemManager
extends StandardFileSystemManager {
    protected Vector<VFSConnection> connections = null;
    protected boolean monitored = false;
    protected JFrame mainWindow = null;
    protected int autoWarnSeconds = 5;

    public VFSFileSystemManager() {
        this(StandardFileSystemManager.class.getResource("providers.xml"));
        try {
            Class.forName("jcifs.smb.SmbException");
            super.addProvider("smb", (FileProvider)new SmbFileProvider());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VFSFileSystemManager(URL configuri) {
        if (configuri == null) {
            throw new NullPointerException();
        }
        this.connections = new Vector(0);
        try {
            Class<?> clazz = Class.forName("org.apache.commons.vfs2.impl.StandardFileSystemManager");
            super.setClassLoader(clazz.getClassLoader());
            super.setConfiguration(configuri);
            super.init();
            try {
                Class.forName("jcifs.smb.SmbException");
                super.addProvider("smb", (FileProvider)new SmbFileProvider());
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.connections != null) {
            this.connections.removeAllElements();
        }
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map getProviders() {
        try {
            return (Map)ReflectionUtils.getDeclaredField((Object)this, DefaultFileSystemManager.class, "providers");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileProvider getProvider(String scheme) {
        try {
            return (FileProvider)this.getProviders().get(scheme);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileOperationProvider removeOperationProvider(String protocol) {
        try {
            return (FileOperationProvider)this.getProviders().remove(protocol);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.resolveFile(uri, (VFSConnection)null);
    }

    public FileObject resolveFile(String uri, VFSConnection vfsconn) throws FileSystemException {
        if (!uri.startsWith("file:/") && SwingUtilities.isEventDispatchThread()) {
            new Throwable("Network files must not be resolved from EDT!").printStackTrace();
        }
        FileSystemOptions options = vfsconn != null ? vfsconn.getFileSystemOptions() : this.getBestFileSystemOptions(uri);
        uri = VFSUtils.addMissingCredentials(uri, vfsconn != null ? vfsconn : this.getBestConnection(uri));
        return super.resolveFile(uri, options);
    }

    public FileObject resolveFile(String uri, FileSystemOptions options) throws FileSystemException {
        return this.resolveFile(uri, options, null);
    }

    public FileObject resolveFile(String uri, FileSystemOptions options, VFSConnection vfsconn) throws FileSystemException {
        if (!uri.startsWith("file:/") && SwingUtilities.isEventDispatchThread()) {
            new Throwable("Network files must not be resolved from EDT!").printStackTrace();
        }
        uri = VFSUtils.addMissingCredentials(uri, vfsconn != null ? vfsconn : this.getBestConnection(uri));
        return super.resolveFile(uri, options);
    }

    public FileObject resolveFile(File baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, null);
    }

    public FileObject resolveFile(File baseFile, String uri, VFSConnection vfsconn) throws FileSystemException {
        FileSystemOptions options = vfsconn != null ? vfsconn.getFileSystemOptions() : this.getBestFileSystemOptions(uri);
        uri = VFSUtils.addMissingCredentials(uri, vfsconn != null ? vfsconn : this.getBestConnection(uri));
        try {
            Method method_getLocalFileProvider = DefaultFileSystemManager.class.getDeclaredMethod("getLocalFileProvider", new Class[0]);
            method_getLocalFileProvider.setAccessible(true);
            LocalFileProvider provider = (LocalFileProvider)method_getLocalFileProvider.invoke((Object)this, new Object[0]);
            return super.resolveFile(provider.findLocalFile(baseFile), uri, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(FileObject baseFile, String uri) throws FileSystemException {
        return this.resolveFile(baseFile, uri, (VFSConnection)null);
    }

    public FileObject resolveFile(FileObject baseFile, String uri, VFSConnection vfsconn) throws FileSystemException {
        if (!String.valueOf(baseFile).startsWith("file:/") && SwingUtilities.isEventDispatchThread()) {
            new Throwable("Network files must not be resolved from EDT!").printStackTrace();
        }
        FileSystemOptions options = vfsconn != null ? vfsconn.getFileSystemOptions() : this.getBestFileSystemOptions(uri);
        uri = VFSUtils.addMissingCredentials(uri, vfsconn != null ? vfsconn : this.getBestConnection(uri));
        return super.resolveFile(baseFile, uri, options);
    }

    public Vector<VFSConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(Vector<VFSConnection> connections) {
        if (connections == null) {
            throw new NullPointerException();
        }
        this.connections = connections;
    }

    public void addConnection(VFSConnection vfsconn) {
        if (vfsconn == null) {
            throw new NullPointerException();
        }
        this.connections.addElement(vfsconn);
    }

    public VFSConnection getBestConnection(String uri) {
        VFSConnection[] candidates = VFSUtils.findVFSConnections(this, uri);
        VFSConnection conn = null;
        if (candidates.length >= 1) {
            String mapped = VFSUtils.getDisplayURIUsernameOnly(uri, candidates[0]);
            CommonsSettings.log(Level.FINE, "Using first-best configured connection " + candidates[0].getName("?") + " for uri=" + mapped);
            conn = candidates[0];
        }
        return conn;
    }

    protected FileSystemOptions getBestFileSystemOptions(String uri) {
        VFSConnection[] candidates = VFSUtils.findVFSConnections(this, uri);
        FileSystemOptions options = null;
        if (candidates.length >= 1) {
            String mapped = VFSUtils.getDisplayURIUsernameOnly(uri, candidates[0]);
            CommonsSettings.log(Level.FINE, "Using first-best configured connection options " + candidates[0].getName("?") + " for uri=" + mapped);
            options = candidates[0].getFileSystemOptions();
        } else {
            try {
                String scheme = new VFSURI(uri).getScheme();
                options = VFSConnection.getDefaultFileSystemOptions(scheme, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return options;
    }

    public void configureUnit(String id, Configuration config) {
        this.connections.removeAllElements();
        String prefix = id + ":connections";
        int count = config.getInt(prefix + ".count", 0);
        if (count == 0) {
            prefix = "VFS:connections";
            count = config.getInt(prefix + ".count", 0);
        }
        for (int i = 0; i < count; ++i) {
            String protocol;
            String uniqueid;
            Configuration innerconfig = (Configuration)config.getObject(prefix + '.' + (i + 1) + '.', Configuration.class, null);
            if (innerconfig == null || (uniqueid = (String)innerconfig.getObject("VAR_CONNECTION_ID", String.class, null)) == null || (protocol = (String)innerconfig.getObject("VAR_PROTOCOL", String.class, null)) == null) continue;
            FileSystemOptions inneroptions = (FileSystemOptions)config.getObject(prefix + '.' + (i + 1) + ".options", FileSystemOptions.class, null);
            if (inneroptions == null) {
                inneroptions = VFSConnection.getDefaultFileSystemOptions(protocol, null);
            }
            VFSConnection vfsconn = VFSConnection.createConnection(this, protocol, uniqueid, innerconfig, inneroptions);
            this.connections.addElement(vfsconn);
        }
    }

    public void storeUnit(String id, Configuration config) {
        int size = this.connections.size();
        String prefix = id + ":connections";
        config.setInt(prefix + ".count", size);
        for (int i = 0; i < size; ++i) {
            Configuration innerconfig = this.connections.elementAt(i).getCache();
            if (!innerconfig.getBoolean("PARAM_SAVE_PWD", false) && innerconfig.contains("PARAM_USER_PWD") && !((String)innerconfig.getObject("PARAM_USER_PWD", String.class, (Object)"")).isEmpty()) {
                innerconfig.setObject("PARAM_USER_PWD", "");
            }
            config.setObject(prefix + '.' + (i + 1) + '.', innerconfig);
            FileSystemOptions inneroptions = this.connections.elementAt(i).getFileSystemOptions();
            config.setObject(prefix + '.' + (i + 1) + ".options", inneroptions);
        }
    }

    public void unitRegistered(ApplicationModel model, String id) {
    }

    public void unitUnregistered(ApplicationModel model, String id) {
    }

    public void setMonitored(boolean enable) {
        this.monitored = enable;
    }

    public void setMainWindow(JFrame window) {
        this.mainWindow = window;
    }

    public void setAutoWarnSeconds(int seconds) {
        this.autoWarnSeconds = seconds;
    }
}

