/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.lf.commons.lang.JavaUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.gdrive.GDriveClientWrapper;
import com.lf.vfslib.gdrive.GDriveFileNameParser;
import com.lf.vfslib.gdrive.GDriveFileSystem;
import com.lf.vfslib.gdrive.GDriveFileSystemConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;

public final class GDriveFileProvider
extends AbstractOriginatingFileProvider {
    private GoogleAuthorizationCodeFlow authFlow = null;
    private String appName = null;
    private String redirectURI = null;
    private VFSLib vfsLib = null;
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.RANDOM_ACCESS_READ, Capability.READ_CONTENT, Capability.RENAME, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.URI, Capability.WRITE_CONTENT));

    public GDriveFileProvider() throws InstantiationException {
        throw new InstantiationException("Do not use this constructor!");
    }

    public GDriveFileProvider(Object authflow, String appname, String redirecturi, VFSLib vfslib) {
        if (authflow == null) {
            throw new NullPointerException();
        }
        if (appname == null) {
            throw new NullPointerException();
        }
        if (!(authflow instanceof GoogleAuthorizationCodeFlow)) {
            throw new IllegalArgumentException("Parameter authflow must be of type GoogleAuthorizationCodeFlow");
        }
        if (redirecturi == null) {
            throw new NullPointerException();
        }
        if (vfslib == null) {
            throw new NullPointerException();
        }
        if (!JavaUtils.isMethodCalled(VFSLib.class, "addProviderGoogleDrive")) {
            VFSLibSettings.logMessage("VFSLIB-0021", Level.SEVERE);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0021"));
        }
        try {
            Field field = VFSLib.class.getDeclaredField("licenseManager");
            field.setAccessible(true);
            Object obj = field.get(vfslib);
            Method method = obj.getClass().getDeclaredMethod("checkLicense", Object.class);
            method.setAccessible(true);
            method.invoke(obj, new Object[]{this});
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        this.authFlow = (GoogleAuthorizationCodeFlow)authflow;
        this.appName = appname;
        this.redirectURI = redirecturi;
        this.vfsLib = vfslib;
        this.setFileNameParser(GDriveFileNameParser.getSharedInstance());
    }

    public GoogleAuthorizationCodeFlow getAuthFlow() {
        return this.authFlow;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions options) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        GDriveClientWrapper client = GDriveClientWrapper.getGDriveClientWrapper(rootName, options, this.vfsLib, this);
        GDriveClientWrapper.unlockGDriveClientWrapper(client);
        return new GDriveFileSystem(rootName, options, this.vfsLib, this);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return GDriveFileSystemConfigBuilder.getSharedInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

