/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.ParentReference;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.gdrive.GDriveClientWrapper;
import com.lf.vfslib.gdrive.GDriveFileSystem;
import com.lf.vfslib.gdrive.GDriveFileSystemConfigBuilder;
import com.lf.vfslib.gdrive.GDriveRandomAccessContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class GDriveFileObject
extends AbstractFileObject
implements FileObject {
    protected final GDriveFileSystem fileSystem;
    protected String relPath = null;
    protected boolean inRefresh = false;
    protected File googleFile = null;
    protected String rootID = null;

    public GDriveFileObject(AbstractFileName name, GDriveFileSystem filesystem) throws FileSystemException {
        super(name, (AbstractFileSystem)filesystem);
        this.fileSystem = filesystem;
        this.relPath = UriParser.decode((String)filesystem.getRootName().getRelativeName((FileName)name));
        if (this.relPath.equals(".")) {
            this.relPath = "/";
        } else if (!this.relPath.startsWith("/")) {
            this.relPath = '/' + this.relPath;
        }
    }

    private String getGooglePath() {
        if (this.relPath.equals("/")) {
            return "";
        }
        return this.relPath.substring(1);
    }

    private String getGoogleTitle() {
        if (this.relPath.equals("/")) {
            return "root";
        }
        return this.relPath.substring(this.relPath.lastIndexOf(47) + 1);
    }

    private boolean isInRoot() {
        if (this.relPath.equals("/")) {
            return true;
        }
        return this.relPath.lastIndexOf(47) == 0;
    }

    private String getRootID() {
        if (this.rootID == null) {
            try {
                GDriveClientWrapper client = this.fileSystem.getClient();
                About about = (About)client.driveClient.about().get().execute();
                this.rootID = about.getRootFolderId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.rootID;
    }

    protected void doDetach() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected FileType doGetType() throws Exception {
        this.statSelf();
        if (this.googleFile != null) {
            if (this.googleFile.getMimeType().equals("application/vnd.google-apps.folder")) {
                return FileType.FOLDER;
            }
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statSelf() throws Exception {
        block10: {
            if (this.googleFile != null) {
                return;
            }
            GDriveClientWrapper client = this.fileSystem.getClient();
            try {
                if (this.relPath.equals("/")) {
                    Drive.Files.Get request = client.driveClient.files().get(this.getRootID());
                    this.googleFile = (File)request.execute();
                    break block10;
                }
                String parentid = this.getRootID();
                String[] paths = this.getGooglePath().split("([/])");
                for (int i = 0; i < paths.length; ++i) {
                    String next = paths[i];
                    Drive.Files.List request = client.driveClient.files().list();
                    request.setQ("title='" + next + "' AND trashed=false AND '" + parentid + "' in parents");
                    List list = ((FileList)request.execute()).getItems();
                    if (list.size() == 1) {
                        if (i == paths.length - 1) {
                            this.googleFile = (File)list.get(0);
                            continue;
                        }
                        parentid = ((File)list.get(0)).getId();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.googleFile = null;
            }
            finally {
                this.fileSystem.putClient(client);
            }
        }
    }

    protected void onChange() throws Exception {
        this.googleFile = null;
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        this.statSelf();
        GDriveClientWrapper client = this.fileSystem.getClient();
        try {
            File file = this.doCreateEntry(client, "application/vnd.google-apps.folder");
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        this.statSelf();
        try {
            DateTime modtime = this.googleFile.getModifiedDate();
            if (modtime != null) {
                return modtime.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_MOD_TIME_ERROR"));
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.statSelf();
        try {
            this.googleFile.setModifiedDate(new DateTime(modtime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new FileSystemException(VFSLibSettings.getUserText(GDriveClientWrapper.class, "SET_MOD_TIME_ERROR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        this.statSelf();
        GDriveClientWrapper client = this.fileSystem.getClient();
        try {
            FileSystemOptions fsoptions = this.fileSystem.getFileSystemOptions();
            Boolean usetrash = GDriveFileSystemConfigBuilder.getSharedInstance().getUseTrash(fsoptions);
            if (usetrash == null || usetrash.booleanValue()) {
                Drive.Files.Trash request = client.driveClient.files().trash(this.googleFile.getId());
                request.execute();
            } else {
                Drive.Files.Delete request = client.driveClient.files().delete(this.googleFile.getId());
                request.execute();
            }
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        this.statSelf();
        GDriveClientWrapper client = this.fileSystem.getClient();
        try {
            File file = new File();
            file.setTitle(newfile.getName().getBaseName());
            Drive.Files.Patch request = client.driveClient.files().patch(this.googleFile.getId(), file);
            request.setFields("title");
            request.execute();
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileObject[] array = null;
        GDriveClientWrapper client = this.fileSystem.getClient();
        FileSystemManager fsmanager = this.getFileSystem().getFileSystemManager();
        this.statSelf();
        try {
            Drive.Files.List request = client.driveClient.files().list();
            if (this.relPath.equals("/")) {
                request.setQ("'" + this.getRootID() + "' in parents AND trashed=false");
            } else {
                request.setQ("'" + this.googleFile.getId() + "' in parents AND trashed=false");
            }
            FileList filelist = (FileList)request.execute();
            List list = filelist.getItems();
            int size = list.size();
            array = new FileObject[size];
            for (int i = 0; i < size; ++i) {
                File child = (File)list.get(i);
                array[i] = this.fileSystem.resolveFile(fsmanager.resolveName(this.getName(), UriParser.encode((String)child.getTitle()), NameScope.CHILD));
                ((GDriveFileObject)array[i]).googleFile = child;
            }
        }
        finally {
            this.fileSystem.putClient(client);
        }
        return array;
    }

    protected String[] doListChildren() throws Exception {
        FileObject[] childs = this.doListChildrenResolved();
        String[] result = new String[childs.length];
        for (int i = 0; i < childs.length; ++i) {
            result[i] = String.valueOf(childs[i]);
        }
        return result;
    }

    protected long doGetContentSize() throws Exception {
        this.statSelf();
        try {
            return this.googleFile.getFileSize();
        }
        catch (Exception e) {
            throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_SIZE_ERROR"));
        }
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new GDriveRandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        this.statSelf();
        if (!this.getType().hasContent()) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "READ_NOT_FILE_ERROR");
            throw new FileSystemException(text, (Object)this.getName());
        }
        GDriveClientWrapper client = this.fileSystem.getClient();
        GDriveFileSystem gDriveFileSystem = this.fileSystem;
        synchronized (gDriveFileSystem) {
            HttpResponse response = client.driveClient.getRequestFactory().buildGetRequest(new GenericUrl(this.googleFile.getDownloadUrl())).execute();
            GDriveInputStream gDriveInputStream = new GDriveInputStream(client, response.getContent());
            return gDriveInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        this.statSelf();
        GDriveClientWrapper client = this.fileSystem.getClient();
        GDriveFileSystem gDriveFileSystem = this.fileSystem;
        synchronized (gDriveFileSystem) {
            File file = this.doCreateEntry(client, "text/plain");
            PipedOutputStream postream = new PipedOutputStream();
            PipedInputStream pistream = new PipedInputStream(postream);
            InputStreamContent content = new InputStreamContent(file.getMimeType(), (InputStream)pistream);
            final Drive.Files.Update request = client.driveClient.files().update(file.getId(), file, (AbstractInputStreamContent)content);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        request.execute();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, "[vfslib] Update Requester");
            thread.setPriority(1);
            thread.start();
            GDriveOutputStream gDriveOutputStream = new GDriveOutputStream(client, postream, thread);
            return gDriveOutputStream;
        }
    }

    private File doCreateEntry(GDriveClientWrapper client, String mimetype) throws Exception {
        this.statSelf();
        File body = new File();
        body.setTitle(this.getGoogleTitle());
        if (mimetype != null) {
            body.setMimeType(mimetype);
        }
        Vector<ParentReference> parentReferences = null;
        if (this.isInRoot()) {
            parentReferences = new Vector<ParentReference>(1);
            parentReferences.add(new ParentReference().setId(this.getRootID()));
        } else {
            GDriveFileObject parent = (GDriveFileObject)this.getParent();
            parent.statSelf();
            if (parent.googleFile != null) {
                parentReferences = new Vector(1);
                parentReferences.add(new ParentReference().setId(parent.googleFile.getId()));
            }
        }
        if (parentReferences != null) {
            body.setParents(parentReferences);
            Drive.Files.Insert request = client.driveClient.files().insert(body);
            File file = (File)request.execute();
            return file;
        }
        return null;
    }

    public VFSLib getVFSLib() {
        return this.fileSystem.getVFSLib();
    }

    private class GDriveOutputStream
    extends MonitorOutputStream {
        private GDriveClientWrapper client;
        private Thread requester;

        public GDriveOutputStream(GDriveClientWrapper client, OutputStream out, Thread requester) {
            super(out);
            this.client = null;
            this.requester = null;
            this.client = client;
            this.requester = requester;
        }

        protected void onClose() throws IOException {
            try {
                this.requester.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            GDriveFileObject.this.fileSystem.putClient(this.client);
        }
    }

    private class GDriveInputStream
    extends MonitorInputStream {
        private GDriveClientWrapper client;

        public GDriveInputStream(GDriveClientWrapper client, InputStream in) {
            super(in);
            this.client = null;
            this.client = client;
        }

        protected void onClose() throws IOException {
            GDriveFileObject.this.fileSystem.putClient(this.client);
        }
    }
}

