/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.google.api.services.drive.Drive;
import com.lf.commons.i18n.Localize;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.gdrive.GDriveClientFactory;
import com.lf.vfslib.gdrive.GDriveFileProvider;
import com.lf.vfslib.gdrive.GDriveFileSystemConfigBuilder;
import com.lf.vfslib.net.ClientPool;
import com.lf.vfslib.net.ClientWrapper;
import java.beans.Beans;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;

public class GDriveClientWrapper
implements ClientWrapper {
    protected GenericFileName root = null;
    protected FileSystemOptions fileSystemOptions = null;
    protected VFSLib vfsLib = null;
    protected GDriveFileProvider provider = null;
    protected Drive driveClient = null;

    @Localize(value={@Localize.Variable(name="CONNECT_ERROR", value="Could not connect to Google Drive server at %server%"), @Localize.Variable(name="SET_MOD_TIME_ERROR", value="Last modification time not set")})
    public GDriveClientWrapper() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    GDriveClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, GDriveFileProvider provider) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = options;
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
        this.createClient();
    }

    protected void createClient() throws FileSystemException {
        try {
            this.driveClient = GDriveClientFactory.createClient(this.root, this.fileSystemOptions, this.provider.getApplicationName(), this.provider.getAuthFlow(), this.vfsLib);
        }
        catch (Exception e) {
            String text = VFSLibSettings.getUserText(GDriveClientWrapper.class, "CONNECT_ERROR");
            throw new FileSystemException(text.replaceAll("(%server%)", String.valueOf(this.root)), (Object)this.root, (Throwable)e);
        }
    }

    protected Drive getClient() {
        return this.driveClient;
    }

    protected FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    @Override
    public boolean disconnectClient() {
        return true;
    }

    @Override
    public String getURLID() {
        return this.toString();
    }

    public static GDriveClientWrapper getGDriveClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, GDriveFileProvider provider) throws FileSystemException {
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        ClientPool pool = ClientPool.getSharedInstance();
        try {
            ClientWrapper recycled = pool.getFreeClient(GDriveClientWrapper.getClientURLID(root, options, vfslib));
            if (recycled != null) {
                return (GDriveClientWrapper)recycled;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GDriveClientWrapper wrapper = new GDriveClientWrapper(root, options, vfslib, provider);
        pool.addClient(wrapper);
        return wrapper;
    }

    public static void unlockGDriveClientWrapper(GDriveClientWrapper wrapper) {
        ClientPool.getSharedInstance().unlockClient(wrapper);
    }

    public String toString() {
        return GDriveClientWrapper.getClientURLID(this.root, this.fileSystemOptions, this.vfsLib);
    }

    public static String getClientURLID(GenericFileName root, FileSystemOptions options, VFSLib vfslib) {
        GDriveFileSystemConfigBuilder builder;
        String username;
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        if ((username = (builder = GDriveFileSystemConfigBuilder.getSharedInstance()).getAccountDisplayName(options)) == null) {
            username = "anonymous";
        }
        return vfslib.getSchemeGoogleDrive() + "://" + username + '@' + root.getHostName();
    }
}

