/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.dropbox.DbxFileObject;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class DbxRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    protected DbxFileObject fileObject = null;
    protected DataInputStream dataInputStream = null;
    protected InputStream dbxInputStream = null;

    DbxRandomAccessContent(DbxFileObject fileobject, RandomAccessMode mode) {
        super(mode);
        if (fileobject == null) {
            throw new NullPointerException();
        }
        this.fileObject = fileobject;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "RANDOM_ACCESS_INVALID_POSITION_ERROR");
            throw new FileSystemException(text, new Object[]{pos});
        }
        if (this.dataInputStream != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dataInputStream != null) {
            return this.dataInputStream;
        }
        this.dbxInputStream = this.fileObject.getInputStream();
        int i = 0;
        while ((long)i < this.filePointer) {
            this.dbxInputStream.read();
            ++i;
        }
        this.dataInputStream = new DataInputStream(new FilterInputStream(this.dbxInputStream){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++DbxRandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    DbxRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    DbxRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public void close() throws IOException {
                DbxRandomAccessContent.this.close();
            }
        });
        return this.dataInputStream;
    }

    public void close() throws IOException {
        if (this.dataInputStream != null) {
            this.dbxInputStream.close();
            DataInputStream oldstream = this.dataInputStream;
            this.dataInputStream = null;
            oldstream.close();
            this.dbxInputStream = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

