/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.lf.commons.i18n.Localize;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxFileSystem;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;

public class DbxFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static DbxFileSystemConfigBuilder sharedInstance;
    public static final String DISPLAY_NAME;
    public static final String ACCESS_TOKEN;
    public static final String CHUNK_SIZE;
    protected VFSLib vfsLib = null;

    @Localize(value={@Localize.Variable(name="CHUNK_SIZE", value="Parameter chunksize %chunksize% is invalid")})
    public DbxFileSystemConfigBuilder() {
        this(null);
    }

    public DbxFileSystemConfigBuilder(VFSLib vfslib) {
        super("dropbox.");
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
    }

    public static synchronized DbxFileSystemConfigBuilder getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DbxFileSystemConfigBuilder();
        }
        return sharedInstance;
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return DbxFileSystem.class;
    }

    public void setAccountDisplayName(FileSystemOptions options, String name) {
        super.setParam(options, DISPLAY_NAME, (Object)name);
    }

    public String getAccountDisplayName(FileSystemOptions options) {
        return (String)super.getParam(options, DISPLAY_NAME);
    }

    public void setAccessToken(FileSystemOptions options, String token) {
        super.setParam(options, ACCESS_TOKEN, (Object)token);
    }

    public String getAccessToken(FileSystemOptions options) {
        return (String)super.getParam(options, ACCESS_TOKEN);
    }

    public void setChunkSize(FileSystemOptions options, Integer chunksize) {
        if (chunksize != null && chunksize <= 0) {
            String text = VFSLibSettings.getUserText(DbxFileSystemConfigBuilder.class, "CHUNK_SIZE");
            throw new IllegalArgumentException(text.replaceAll("(%chunksize%)", String.valueOf(chunksize)));
        }
        super.setParam(options, CHUNK_SIZE, (Object)chunksize);
    }

    public Integer getChunkSize(FileSystemOptions options) {
        return super.getInteger(options, CHUNK_SIZE);
    }

    static {
        DISPLAY_NAME = DbxFileSystemConfigBuilder.class.getName() + ".DISPLAY_NAME";
        ACCESS_TOKEN = DbxFileSystemConfigBuilder.class.getName() + ".ACCESS_TOKEN";
        CHUNK_SIZE = DbxFileSystemConfigBuilder.class.getName() + ".CHUNK_SIZE";
    }
}

