/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWriteMode;
import com.lf.commons.config.ConfigUtils;
import com.lf.commons.lang.StringUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.dropbox.DbxFileSystem;
import com.lf.vfslib.dropbox.DbxFileSystemConfigBuilder;
import com.lf.vfslib.dropbox.DbxRandomAccessContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class DbxFileObject
extends AbstractFileObject
implements FileObject {
    public static final DateFormat DATE_FORMAT_LAST_MODIFIED = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz");
    protected final DbxFileSystem fileSystem;
    protected String relPath = null;
    protected boolean inRefresh = false;
    protected DbxEntry dbxEntry = null;
    protected Properties props = null;

    public DbxFileObject(AbstractFileName name, DbxFileSystem filesystem) throws FileSystemException {
        super(name, (AbstractFileSystem)filesystem);
        this.fileSystem = filesystem;
        this.relPath = UriParser.decode((String)filesystem.getRootName().getRelativeName((FileName)name));
        if (this.relPath.equals(".")) {
            this.relPath = "/";
        } else if (!this.relPath.startsWith("/")) {
            this.relPath = '/' + this.relPath;
        }
    }

    protected void doDetach() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected FileType doGetType() throws Exception {
        this.statSelf();
        if (this.dbxEntry != null) {
            if (this.dbxEntry.isFile()) {
                return FileType.FILE;
            }
            if (this.dbxEntry.isFolder()) {
                return FileType.FOLDER;
            }
        }
        return FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statSelf() throws Exception {
        if (this.dbxEntry != null) {
            return;
        }
        DbxClientWrapper client = this.fileSystem.getClient();
        try {
            this.dbxEntry = client.dbxClient.getMetadata(this.relPath);
            this.props = this.dbxEntry != null ? ConfigUtils.convertFromDbxEntry(this.dbxEntry) : null;
        }
        catch (Exception e) {
            this.dbxEntry = null;
            this.props = null;
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    protected void onChange() throws Exception {
        this.dbxEntry = null;
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        this.statSelf();
        DbxClientWrapper client = this.fileSystem.getClient();
        try {
            client.dbxClient.createFolder(this.relPath);
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        this.statSelf();
        if (this.props != null) {
            try {
                String modtime = this.props.getProperty("clientMtime");
                if (modtime != null) {
                    return DATE_FORMAT_LAST_MODIFIED.parse(modtime).getTime();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_MOD_TIME_ERROR"));
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        this.statSelf();
        DbxClientWrapper client = this.fileSystem.getClient();
        try {
            client.dbxClient.delete(this.relPath);
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        block6: {
            this.statSelf();
            DbxClientWrapper client = this.fileSystem.getClient();
            try {
                client.dbxClient.move(this.relPath, ((DbxFileObject)newfile).relPath);
            }
            catch (DbxException dbxexc) {
                String msg = dbxexc.getMessage();
                if (dbxexc instanceof DbxException.BadResponse && StringUtils.matchesRegex(msg, ".*not expecting \"hash\" field.*")) {
                    break block6;
                }
                throw dbxexc;
            }
            finally {
                this.fileSystem.putClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileObject[] array = null;
        DbxClientWrapper client = this.fileSystem.getClient();
        FileSystemManager fsmanager = this.getFileSystem().getFileSystemManager();
        this.statSelf();
        try {
            DbxEntry.WithChildren listing = client.dbxClient.getMetadataWithChildren(this.relPath);
            int size = listing.children.size();
            array = new FileObject[size];
            for (int i = 0; i < size; ++i) {
                DbxEntry child = (DbxEntry)listing.children.get(i);
                array[i] = this.fileSystem.resolveFile(fsmanager.resolveName(this.getName(), UriParser.encode((String)child.path), NameScope.CHILD));
            }
        }
        finally {
            this.fileSystem.putClient(client);
        }
        return array;
    }

    protected String[] doListChildren() throws Exception {
        FileObject[] childs = this.doListChildrenResolved();
        String[] result = new String[childs.length];
        for (int i = 0; i < childs.length; ++i) {
            result[i] = String.valueOf(childs[i]);
        }
        return result;
    }

    protected long doGetContentSize() throws Exception {
        this.statSelf();
        if (this.props != null) {
            try {
                return Long.parseLong(this.props.getProperty("numBytes"));
            }
            catch (Exception e) {
                throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_SIZE_ERROR"));
            }
        }
        return -1L;
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new DbxRandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        this.statSelf();
        if (!this.getType().hasContent()) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "READ_NOT_FILE_ERROR");
            throw new FileSystemException(text, (Object)this.getName());
        }
        DbxClientWrapper client = this.fileSystem.getClient();
        DbxFileSystem dbxFileSystem = this.fileSystem;
        synchronized (dbxFileSystem) {
            DbxClient.Downloader downloader = client.dbxClient.startGetFile(this.relPath, null);
            DbxInputStream dbxInputStream = new DbxInputStream(client, downloader, downloader.body);
            return dbxInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        this.statSelf();
        DbxClientWrapper client = this.fileSystem.getClient();
        DbxFileSystem dbxFileSystem = this.fileSystem;
        synchronized (dbxFileSystem) {
            FileSystemOptions fsoptions = this.fileSystem.getFileSystemOptions();
            Integer value = DbxFileSystemConfigBuilder.getSharedInstance().getChunkSize(fsoptions);
            if (value == null) {
                value = 4096;
            }
            DbxClient.Uploader uploader = client.dbxClient.startUploadFileChunked(value.intValue(), this.relPath, DbxWriteMode.force(), -1L);
            DbxOutputStream dbxOutputStream = new DbxOutputStream(client, uploader, uploader.getBody());
            return dbxOutputStream;
        }
    }

    public VFSLib getVFSLib() {
        return this.fileSystem.getVFSLib();
    }

    private class DbxOutputStream
    extends MonitorOutputStream {
        private DbxClientWrapper client;
        private DbxClient.Uploader uploader;

        public DbxOutputStream(DbxClientWrapper client, DbxClient.Uploader uploader, OutputStream out) {
            super(out);
            this.client = null;
            this.uploader = null;
            this.client = client;
            this.uploader = uploader;
        }

        protected void onClose() throws IOException {
            try {
                this.uploader.finish();
                this.uploader.close();
            }
            catch (DbxException dbexc) {
                throw new IOException(dbexc);
            }
            finally {
                DbxFileObject.this.fileSystem.putClient(this.client);
            }
        }
    }

    private class DbxInputStream
    extends MonitorInputStream {
        private DbxClientWrapper client;
        private DbxClient.Downloader downloader;

        public DbxInputStream(DbxClientWrapper client, DbxClient.Downloader downloader, InputStream in) {
            super(in);
            this.client = null;
            this.downloader = null;
            this.client = client;
            this.downloader = downloader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                this.downloader.close();
            }
            finally {
                DbxFileObject.this.fileSystem.putClient(this.client);
            }
        }
    }
}

