/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.msg;

import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Locale;
import com.lf.vfslib.net.VFSFileSystemManager;
import java.beans.Beans;
import java.text.DecimalFormat;
import java.util.Hashtable;
import org.apache.commons.vfs2.FileObject;

public class MessageCache {
    protected Hashtable<String, Configuration> cachePagesByRange;
    protected Locale locale;
    protected String id;
    protected FileObject path;

    public MessageCache() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public MessageCache(Locale locale, String id, FileObject path) {
        if (locale == null || id == null || path == null) {
            throw new IllegalArgumentException();
        }
        this.cachePagesByRange = new Hashtable(0);
        this.locale = locale;
        this.id = id;
        this.path = path;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cachePagesByRange != null) {
            this.cachePagesByRange.clear();
        }
    }

    public synchronized String getMessage(String code, boolean prefix) {
        String range;
        int num;
        try {
            num = Integer.parseInt(code);
            range = new DecimalFormat("0000").format(Math.floor((double)num / 100.0) * 100.0);
        }
        catch (Exception e) {
            try {
                int index = code.lastIndexOf(45);
                num = Integer.parseInt(code.substring(index + 1));
                range = new DecimalFormat("0000").format(Math.floor((double)num / 100.0));
            }
            catch (Exception e2) {
                return null;
            }
        }
        String fullnum = new DecimalFormat("0000").format(num);
        Configuration page = this.cachePagesByRange.get(range);
        try {
            String pre;
            String string = pre = prefix ? this.id + '-' + fullnum + ": " : "";
            if (!page.contains(this.id + '-' + fullnum)) {
                return null;
            }
            return pre + page.getObject(this.id + '-' + fullnum, String.class.getName());
        }
        catch (Exception e) {
            if (page == null) {
                String pre;
                page = new Configuration();
                try {
                    String path = this.path.getName().getURI() + '/' + range + ".conf";
                    VFSFileSystemManager vfsmanager = CommonsSettings.getManagerClasspath();
                    FileObject target = vfsmanager.resolveFile(path);
                    page.read(target.getContent().getInputStream());
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.cachePagesByRange.put(range, page);
                String string = pre = prefix ? this.id + '-' + fullnum + ": " : "";
                if (!page.contains(this.id + '-' + fullnum)) {
                    return null;
                }
                return pre + page.getObject(this.id + '-' + fullnum, String.class.getName());
            }
            return null;
        }
    }
}

