/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Localize;
import java.awt.Desktop;
import java.beans.Beans;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.logging.Level;

public final class JavaUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    @Localize(value={@Localize.Variable(name="NUMBER_LOCALE", value="US")})
    public JavaUtils() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public static Object addToArray(Object array, Object newval) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("First parameter must be an array");
        }
        Class<?> arrayclazz = array.getClass().getComponentType();
        if (!arrayclazz.isPrimitive()) {
            arrayclazz = JavaUtils.mapToPrimitive(arrayclazz);
        }
        if (newval != null) {
            Class newvalclazz = newval.getClass();
            if (!newvalclazz.isPrimitive()) {
                newvalclazz = JavaUtils.mapToPrimitive(newvalclazz);
            }
            if (!arrayclazz.isAssignableFrom(newvalclazz)) {
                String msg = "Incompatible data types: " + arrayclazz.getName() + " != " + newvalclazz.getName();
                throw new IllegalArgumentException(msg);
            }
        }
        arrayclazz = array.getClass().getComponentType();
        Object temp = Array.newInstance(arrayclazz, Array.getLength(array) + 1);
        System.arraycopy(array, 0, temp, 0, Array.getLength(array));
        Array.set(temp, Array.getLength(array), newval);
        return temp;
    }

    public static boolean elementOf(Object object, Object array) {
        if (array.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                Object arrayobj = Array.get(array, i);
                if (arrayobj == null || !arrayobj.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static Class mapToPrimitive(Class clazz) {
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Void.class)) {
            return Void.TYPE;
        }
        return clazz;
    }

    public static String getMethod(boolean full) {
        boolean found = false;
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            String clazz = trace[i].getClassName();
            String method = trace[i].getMethodName();
            if (found) {
                if (full) {
                    return clazz + '.' + method + "()";
                }
                return clazz.substring(clazz.lastIndexOf(46) + 1) + '.' + method + "()";
            }
            if (!clazz.equals(JavaUtils.class.getName())) continue;
            found = true;
        }
        return null;
    }

    public static String convertToHex(byte b, boolean uppercase) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = ret + (uppercase ? Integer.toHexString(value).toUpperCase() : Integer.toHexString(value));
        return ret;
    }

    public static boolean isMethodCalled(Class clazz, String method) {
        String pattern = clazz.getName() + '.' + method;
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = trace.length - 1; i >= 0; --i) {
            String value = trace[i].getClassName() + '.' + trace[i].getMethodName();
            if (!value.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public static void browse(String uri) {
        if (uri == null) {
            CommonsSettings.log(Level.WARNING, "Desired URL " + uri + " is invalid and cannot be browsed");
            return;
        }
        if (uri.startsWith("javahelp://")) {
            try {
                CommonsSettings.showHelpDelegated(uri);
                return;
            }
            catch (Exception ex) {
                CommonsSettings.log(Level.WARNING, "Help system ID \"" + uri + "\" is invalid");
            }
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(uri));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

