/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;

public class DateUtils {
    public static Date getDescriptorDate(Properties props) {
        String date = props.getProperty("DATE");
        String pattern = props.getProperty("DATE_PATTERN");
        String locale = props.getProperty("DATE_LOCALE");
        return DateUtils.getDate(date, pattern, locale);
    }

    public static Date getDate(String date, String pattern, String locale) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, new Locale(locale));
            return formatter.parse(date, new ParsePosition(0));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int calculateDays(Date first, Date second) {
        try {
            GregorianCalendar cal1 = new GregorianCalendar();
            cal1.clear();
            cal1.setTime(new SimpleDateFormat("yyyyMMdd").parse(new SimpleDateFormat("yyyyMMdd").format(first)));
            GregorianCalendar cal2 = new GregorianCalendar();
            cal2.clear();
            cal2.setTime(new SimpleDateFormat("yyyyMMdd").parse(new SimpleDateFormat("yyyyMMdd").format(second)));
            long time1 = cal1.getTimeInMillis();
            long time2 = cal2.getTimeInMillis();
            return Math.abs((int)Math.round((double)(time1 - time2) / 8.64E7));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static Date normalizeDateMidnight(Date date) {
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(new SimpleDateFormat("yyyyMMdd").format(date));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

