/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Locale;
import com.lf.commons.lang.JavaUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LanguageCodes {
    protected Hashtable<String, String[]> cacheNameBy639_1;
    protected Hashtable<String, String[]> cacheNameBy639_2;
    protected Hashtable<String, String> cache639_1ByName;
    protected Hashtable<String, String> cache639_1By639_2;
    protected Hashtable<String, String[]> cache639_2ByName;
    protected Hashtable<String, String[]> cache639_2By639_1;
    protected Hashtable<Locale, Hashtable<String, String[]>> cacheTranslations;
    protected Locale locale;

    public LanguageCodes() {
        this.installInitialCaches();
    }

    protected void installInitialCaches() {
        Configuration config;
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        this.locale = settings.getLogLocale();
        this.cacheNameBy639_1 = new Hashtable(0);
        this.cacheNameBy639_2 = new Hashtable(0);
        this.cache639_2ByName = new Hashtable(0);
        try {
            config = new Configuration();
            config.read(CommonsSettings.class.getResourceAsStream("i18n/" + this.locale + "/languages.conf"));
        }
        catch (Exception e) {
            throw new RuntimeException("Resource file could not be imported!");
        }
        int index = 1;
        boolean finished = false;
        while (!finished) {
            String[] codes;
            int pos;
            String[] names;
            StringTokenizer tokenizer;
            try {
                String name = (String)config.getObject("LANG_" + index + "_NAME", String.class.getName());
                tokenizer = new StringTokenizer(name, ";");
                names = new String[tokenizer.countTokens()];
                pos = 0;
                while (tokenizer.hasMoreTokens()) {
                    names[pos] = tokenizer.nextToken().trim();
                    ++pos;
                }
            }
            catch (Exception e) {
                finished = true;
                continue;
            }
            try {
                String iso639_1 = (String)config.getObject("LANG_" + index + "_ISO639-1", String.class.getName());
                this.cacheNameBy639_1.put(iso639_1, names);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String code = (String)config.getObject("LANG_" + index + "_ISO639-2", String.class.getName());
                tokenizer = new StringTokenizer(code, "/");
                codes = new String[tokenizer.countTokens()];
                pos = 0;
                while (tokenizer.hasMoreTokens()) {
                    codes[pos] = tokenizer.nextToken().trim();
                    this.cacheNameBy639_2.put(codes[pos], names);
                    ++pos;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("No ISO 639-2 code found for language " + names[0] + '!');
            }
            try {
                for (int i = 0; i < names.length; ++i) {
                    this.cache639_2ByName.put(names[i], codes);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++index;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheNameBy639_1 != null) {
            this.cacheNameBy639_1.clear();
        }
        if (this.cacheNameBy639_2 != null) {
            this.cacheNameBy639_2.clear();
        }
        if (this.cache639_1ByName != null) {
            this.cache639_1ByName.clear();
        }
        if (this.cache639_2ByName != null) {
            this.cache639_2ByName.clear();
        }
        if (this.cache639_1By639_2 != null) {
            this.cache639_1By639_2.clear();
        }
        if (this.cache639_2By639_1 != null) {
            this.cache639_2By639_1.clear();
        }
        if (this.cacheTranslations != null) {
            Enumeration<Locale> enumeration = this.cacheTranslations.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable<String, String[]> hash = this.cacheTranslations.get(enumeration.nextElement());
                hash.clear();
            }
            this.cacheTranslations.clear();
        }
    }

    public String get639_1By639_2(String code) {
        try {
            return this.cache639_1By639_2.get(code);
        }
        catch (Exception e) {
            if (this.cache639_1By639_2 == null) {
                this.cache639_1By639_2 = new Hashtable(0);
                Enumeration<String> enumeration = this.cacheNameBy639_1.keys();
                block2: while (enumeration.hasMoreElements()) {
                    String iso639_1 = enumeration.nextElement();
                    String[] names = this.cacheNameBy639_1.get(iso639_1);
                    String name = names[0];
                    int counter = 0;
                    Enumeration<String> enumeration2 = this.cacheNameBy639_2.keys();
                    while (enumeration2.hasMoreElements()) {
                        String iso639_2 = enumeration2.nextElement();
                        names = this.cacheNameBy639_2.get(iso639_2);
                        for (int i = 0; i < names.length; ++i) {
                            if (!names[i].equals(name)) continue;
                            this.cache639_1By639_2.put(iso639_2, iso639_1);
                            ++counter;
                        }
                        if (counter != 2) continue;
                        continue block2;
                    }
                }
            }
            return this.cache639_1By639_2.get(code);
        }
    }

    public String[] get639_2By639_1(String code) {
        try {
            return this.cache639_2By639_1.get(code);
        }
        catch (Exception e) {
            if (this.cache639_2By639_1 == null) {
                this.cache639_2By639_1 = new Hashtable(0);
                Enumeration<String> enumeration = this.cacheNameBy639_1.keys();
                while (enumeration.hasMoreElements()) {
                    String iso639_1 = enumeration.nextElement();
                    String[] names = this.cacheNameBy639_1.get(iso639_1);
                    String name = names[0];
                    String[] codes = this.cache639_2ByName.get(name);
                    this.cache639_2By639_1.put(iso639_1, codes);
                }
            }
            return this.cache639_2By639_1.get(code);
        }
    }

    public String[] get639_2Synonyms(String code) {
        String[] names = this.cacheNameBy639_2.get(code);
        if (names == null) {
            return null;
        }
        String[] codes = this.cache639_2ByName.get(names[0]);
        if (codes == null) {
            return null;
        }
        String[] result = new String[]{};
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i].equals(code)) continue;
            result = (String[])JavaUtils.addToArray(result, codes[i]);
        }
        if (result.length == 0) {
            return null;
        }
        return result;
    }
}

