/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.lang.ReflectionUtils;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class I18NConfiguration
extends Configuration {
    public synchronized int localize(Object target, Class targetclazz, int prefix) {
        if (target == null) {
            throw new NullPointerException("Localization target must not be null");
        }
        if (prefix != 1 && prefix != 2) {
            throw new IllegalArgumentException("Localization prefix mode is invalid");
        }
        int count = 0;
        Class<?> objclazz = target.getClass();
        if (!targetclazz.equals(objclazz) && !ReflectionUtils.isSubclassing(objclazz, targetclazz)) {
            throw new IllegalArgumentException("Object does not apply to class type " + targetclazz);
        }
        Field[] fields = targetclazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (name.startsWith("I18N_")) {
                name = prefix == 1 ? targetclazz.getName() + ':' + name.substring(5) : name.substring(5);
            } else {
                if (!name.endsWith("_I18N")) continue;
                name = prefix == 1 ? targetclazz.getName() + ':' + name.substring(0, name.length() - 5) : name.substring(0, name.length() - 5);
            }
            Class<?> clazz = fields[i].getType();
            fields[i].setAccessible(true);
            try {
                Method method;
                Object value;
                if (clazz.equals(String.class)) {
                    if (!super.contains(name) || (value = super.getObject(name, String.class)) == null) continue;
                    fields[i].set(target, value);
                    ++count;
                    continue;
                }
                if (!ReflectionUtils.isSubclassing(clazz, Component.class)) continue;
                Component comp = (Component)fields[i].get(target);
                if (comp == null) {
                    CommonsSettings.logMessage("COMMONS-0011", Level.WARNING, "(%variable%)", name);
                    String msg = CommonsSettings.getUserMessage("COMMONS-0011");
                    msg = msg.replaceAll("(%variable%)", name);
                    System.err.println(msg);
                    continue;
                }
                boolean textok = true;
                String text = name + ".text";
                try {
                    method = comp.getClass().getMethod("setText", String.class);
                    try {
                        if (super.contains(text) && (value = super.getObject(text, String.class)) != null) {
                            method.invoke((Object)comp, value);
                        }
                    }
                    catch (Exception e) {
                        CommonsSettings.logMessage("COMMONS-0011", Level.WARNING, "(%variable%)", text);
                        textok = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean tooltipok = true;
                String tooltip = name + ".tooltip";
                try {
                    method = comp.getClass().getMethod("setToolTipText", String.class);
                    try {
                        if (super.contains(tooltip) && (value = super.getObject(tooltip, String.class)) != null) {
                            method.invoke((Object)comp, value);
                        }
                    }
                    catch (Exception e) {
                        CommonsSettings.logMessage("COMMONS-0011", Level.WARNING, "(%variable%)", tooltip);
                        tooltipok = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!textok || !tooltipok) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                CommonsSettings.logMessage("COMMONS-0011", Level.WARNING, "(%variable%)", name);
            }
        }
        String[] regex = new String[]{"(%count%)", "(%target%)"};
        String[] replace = new String[]{String.valueOf(count), target.getClass().getName()};
        CommonsSettings.logMessage("COMMONS-0012", Level.CONFIG, regex, replace);
        return count;
    }

    public synchronized int extractLocalization(Object target, int prefix) {
        if (target == null) {
            throw new NullPointerException("Localization target must not be null");
        }
        if (prefix != 1 && prefix != 2) {
            throw new IllegalArgumentException("Localization prefix mode is invalid");
        }
        int count = 0;
        Field[] fields = target.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (name.startsWith("I18N_")) {
                name = prefix == 1 ? target.getClass().getName() + ':' + name.substring(5) : name.substring(5);
            } else {
                if (!name.endsWith("_I18N")) continue;
                name = prefix == 1 ? target.getClass().getName() + ':' + name.substring(0, name.length() - 5) : name.substring(0, name.length() - 5);
            }
            Class<?> clazz = fields[i].getType();
            fields[i].setAccessible(true);
            try {
                Method method;
                Object value;
                if (clazz.equals(String.class)) {
                    value = fields[i].get(target);
                    if (value == null || ((String)value).trim().length() <= 0) continue;
                    super.setObject(name, value);
                    ++count;
                    continue;
                }
                if (!ReflectionUtils.isSubclassing(clazz, Component.class)) continue;
                Component comp = (Component)fields[i].get(target);
                if (comp == null) {
                    CommonsSettings.logMessage("COMMONS-0013", Level.WARNING, "(%variable%)", name);
                    String msg = CommonsSettings.getUserMessage("COMMONS-0013");
                    msg = msg.replaceAll("(%variable%)", name);
                    System.err.println(msg);
                    continue;
                }
                boolean textok = true;
                String text = name + ".text";
                try {
                    method = comp.getClass().getMethod("getText", new Class[0]);
                    try {
                        value = method.invoke((Object)comp, new Object[0]);
                        if (value != null && ((String)value).trim().length() > 0) {
                            super.setObject(text, value);
                        }
                    }
                    catch (Exception e) {
                        CommonsSettings.logMessage("COMMONS-0013", Level.WARNING, "(%variable%)", text);
                        textok = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean tooltipok = true;
                String tooltip = name + ".tooltip";
                try {
                    method = comp.getClass().getMethod("getToolTipText", new Class[0]);
                    try {
                        value = method.invoke((Object)comp, new Object[0]);
                        if (value != null && ((String)value).trim().length() > 0) {
                            super.setObject(tooltip, value);
                        }
                    }
                    catch (Exception e) {
                        CommonsSettings.logMessage("COMMONS-0013", Level.WARNING, "(%variable%)", tooltip);
                        tooltipok = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!textok || !tooltipok) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                CommonsSettings.logMessage("COMMONS-0013", Level.WARNING, "(%variable%)", name);
            }
        }
        String[] regex = new String[]{"(%count%)", "(%target%)"};
        String[] replace = new String[]{String.valueOf(count), target.getClass().getName()};
        CommonsSettings.logMessage("COMMONS-0014", Level.CONFIG, regex, replace);
        return count;
    }
}

