/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.core;

import com.lf.commons.core.HelpDelegate;
import com.lf.commons.i18n.I18NConfiguration;
import com.lf.commons.i18n.I18NUtils;
import com.lf.commons.i18n.Locale;
import com.lf.commons.lang.DeployProps;
import com.lf.commons.msg.MessageCodes;
import com.lf.commons.msg.MessageFactory;
import com.lf.commons.resource.ResourceLocator;
import com.lf.vfslib.net.VFSFileSystemManager;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import org.apache.commons.vfs2.FileObject;

public class CommonsSettings {
    protected static CommonsSettings sharedInstance;
    private String i18nBase;
    private MessageCodes mcodes;
    private Logger logger;
    private Locale userLocale;
    private Locale logLocale;
    private I18NConfiguration i18nTexts;
    private DeployProps version;
    private HelpDelegate helpDelegate;
    protected JMenuItem[] acceleratorItems = null;
    protected static VFSFileSystemManager vfsManagerClasspath;

    public CommonsSettings() {
        if (sharedInstance == null) {
            sharedInstance = this;
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        this.logLocale = new Locale("eng", "US");
        this.version = new DeployProps(ResourceLocator.class.getResourceAsStream("deploy.properties"));
        Logger nologger = Logger.getLogger(this.getClass().getName());
        nologger.setLevel(Level.OFF);
        this.logger = nologger;
        try {
            this.i18nBase = "com.lf.commons.core.i18n";
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mcodes = MessageFactory.createMessageCodes("COMMONS", this.i18nBase, this);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setUserLocale(new Locale("eng", "US"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized VFSFileSystemManager getManagerClasspath() {
        if (vfsManagerClasspath == null) {
            vfsManagerClasspath = new VFSFileSystemManager();
        }
        return vfsManagerClasspath;
    }

    public I18NConfiguration getI18NTexts() {
        return this.i18nTexts;
    }

    public MessageCodes getMessageCodes() {
        return this.mcodes;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Invalid logger");
        }
        this.logger = logger;
        this.logger.log(Level.CONFIG, "[commons] Setting new logger with log level " + logger.getLevel());
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(Locale locale) throws IllegalArgumentException {
        Vector<Locale> locales = this.getSupportedLocales(true);
        if (!locales.contains(locale)) {
            throw new IllegalArgumentException("Unsupported locale " + locale);
        }
        locales = this.getSupportedLocales(false);
        if (!locales.contains(locale)) {
            for (Locale next : locales) {
                Vector<Locale> synonyms = Locale.getLocaleSynonyms(next);
                if (!synonyms.contains(locale)) continue;
                locale = next;
                break;
            }
        }
        if (locale.equals(this.userLocale)) {
            return;
        }
        if (this.i18nTexts == null) {
            this.i18nTexts = new I18NConfiguration();
        } else {
            this.i18nTexts.clear();
        }
        String target = "texts.conf";
        try {
            FileObject path = I18NUtils.getLocalizationVFS(this.i18nBase, locale, this);
            InputStream stream = path.getChild(target).getContent().getInputStream();
            this.i18nTexts.read(stream);
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.i18nTexts.getCache().isEmpty()) {
            this.logger.log(Level.WARNING, "[commons] " + this.mcodes.getMessageReplace("0001", this.logLocale, true, "(%file%)", target));
            throw new IllegalArgumentException("No texts for locale " + locale);
        }
        this.logger.log(Level.CONFIG, "[commons] Loaded internationalized texts " + target);
        this.userLocale = locale;
    }

    public Vector<Locale> getSupportedLocales(boolean synonyms) {
        return I18NUtils.getSupportedLocales(this.i18nBase, this, synonyms);
    }

    public Locale getLogLocale() {
        return this.logLocale;
    }

    public static synchronized CommonsSettings getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new CommonsSettings();
        }
        return sharedInstance;
    }

    public static void log(Level level, String message) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        settings.getLogger().log(level, "[commons] " + message);
    }

    public static void logMessage(Level level, String message) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        settings.getLogger().log(level, "[commons] " + message);
    }

    public static void logMessage(String code, Level level, String regex, String replacement) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        String message = settings.getMessageCodes().getMessageReplace(code, settings.getLogLocale(), true, regex, replacement);
        settings.getLogger().log(level, message);
    }

    public static void logMessage(String code, Level level, String[] regex, String[] replacement) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        String message = settings.getMessageCodes().getMessageReplace(code, settings.getLogLocale(), true, regex, replacement);
        settings.getLogger().log(level, message);
    }

    public static String getUserMessage(String code) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        return settings.getMessageCodes().getMessage(code, settings.getUserLocale(), true);
    }

    public static String getUserText(Class clazz, String variable) {
        String value = null;
        String fullvariable = null;
        try {
            CommonsSettings settings = CommonsSettings.getSharedInstance();
            fullvariable = clazz.getName() + ':' + variable;
            value = (String)settings.getI18NTexts().getObject(fullvariable, String.class);
        }
        catch (Exception e) {
            try {
                value = I18NUtils.getLocalizationValue(clazz, variable);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return value != null ? value : fullvariable;
    }

    public HelpDelegate getHelpDelegate() {
        return this.helpDelegate;
    }

    public static void showHelpDelegated(String link) {
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        HelpDelegate delegate = settings.getHelpDelegate();
        if (delegate != null) {
            delegate.showHelpDelegated(link);
        }
    }
}

