/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.config.handler;

import com.lf.commons.config.ConfigFactory;
import com.lf.commons.config.Configuration;
import com.lf.commons.config.TypeHandler;

public class StringArrayHandler
implements TypeHandler {
    @Override
    public String getType() {
        return String[].class.getName();
    }

    @Override
    public String serialize(Object value) throws IllegalArgumentException {
        try {
            Configuration config = new Configuration();
            config.setCompression("GZIPPED");
            config.setEncoding("UTF-8");
            String[] array = (String[])value;
            config.setInt("COUNT", array.length);
            for (int i = 0; i < array.length; ++i) {
                config.setObject("FIELD_" + (i + 1), array[i]);
            }
            TypeHandler chandler = ConfigFactory.createTypeHandler(Configuration.class);
            return chandler.serialize(config);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object deserialize(String value) throws IllegalArgumentException {
        try {
            TypeHandler chandler = ConfigFactory.createTypeHandler(Configuration.class);
            Configuration config = (Configuration)chandler.deserialize(value);
            int count = config.getInt("COUNT");
            String[] result = new String[count];
            for (int i = 1; i <= count; ++i) {
                result[i - 1] = (String)config.getObject("FIELD_" + i, String.class);
            }
            return result;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }
}

