/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.config.handler;

import com.lf.commons.config.ConfigFactory;
import com.lf.commons.config.TypeHandler;
import com.lf.commons.gui.GUIUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.ImageIcon;

public class ImageIconHandler
implements TypeHandler {
    @Override
    public String getType() {
        return ImageIcon.class.getName();
    }

    @Override
    public String serialize(Object value) throws IllegalArgumentException {
        try {
            ImageIcon icon = (ImageIcon)value;
            String result = null;
            try {
                Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix("png");
                if (it.hasNext()) {
                    ByteArrayOutputStream bostream = new ByteArrayOutputStream();
                    MemoryCacheImageOutputStream iostream = new MemoryCacheImageOutputStream(bostream);
                    ImageWriter writer = it.next();
                    writer.setOutput(iostream);
                    writer.write(GUIUtils.getBufferedImage(icon));
                    iostream.flush();
                    iostream.close();
                    TypeHandler bhandler = ConfigFactory.createTypeHandler(byte[].class);
                    result = bhandler.serialize(bostream.toByteArray());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object deserialize(String value) throws IllegalArgumentException {
        try {
            TypeHandler bhandler = ConfigFactory.createTypeHandler(byte[].class);
            byte[] array = (byte[])bhandler.deserialize(value);
            ByteArrayInputStream istream = new ByteArrayInputStream(array);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            while (istream.available() > 0) {
                int len = istream.read(buffer);
                ostream.write(buffer, 0, len);
            }
            istream.close();
            ostream.flush();
            ostream.close();
            return new ImageIcon(ostream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }
}

