/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.config;

import com.lf.commons.config.ConfigFactory;
import com.lf.commons.config.TypeHandler;
import com.lf.commons.i18n.Locale;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.vfs2.FileSystemOptions;

public class Configuration {
    protected Hashtable<String, String> hash = new Hashtable(10);
    protected Hashtable<String, TypeHandler> handlers = new Hashtable(0);
    protected String compression;
    protected String encoding;
    protected String comment;
    protected boolean sorting;
    protected boolean clearBeforeRead;

    public Configuration() {
        this.installHandlers();
        this.compression = "UNCOMPRESSED";
        this.encoding = "ISO-8859-1 Unicode Escapes";
        this.comment = null;
        this.sorting = false;
        this.clearBeforeRead = true;
    }

    private void installHandlers() {
        this.setHandler(ConfigFactory.createTypeHandler(String.class));
        this.setHandler(ConfigFactory.createTypeHandler(Date.class));
        this.setHandler(ConfigFactory.createTypeHandler(Color.class));
        this.setHandler(ConfigFactory.createTypeHandler(String[].class));
        this.setHandler(ConfigFactory.createTypeHandler(byte[].class));
        this.setHandler(ConfigFactory.createTypeHandler(char[].class));
        this.setHandler(ConfigFactory.createTypeHandler(Configuration.class));
        this.setHandler(ConfigFactory.createTypeHandler(Locale.class));
        this.setHandler(ConfigFactory.createTypeHandler(FileSystemOptions.class));
        this.setHandler(ConfigFactory.createTypeHandler(Byte.class));
        this.setHandler(ConfigFactory.createTypeHandler(Short.class));
        this.setHandler(ConfigFactory.createTypeHandler(Integer.class));
        this.setHandler(ConfigFactory.createTypeHandler(Long.class));
        this.setHandler(ConfigFactory.createTypeHandler(Character.class));
        this.setHandler(ConfigFactory.createTypeHandler(Float.class));
        this.setHandler(ConfigFactory.createTypeHandler(Double.class));
        this.setHandler(ConfigFactory.createTypeHandler(Boolean.class));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.hash != null) {
            this.hash.clear();
        }
        if (this.handlers != null) {
            this.handlers.clear();
        }
    }

    public void clear() {
        try {
            this.hash.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean setVariable(String variable, String value) {
        try {
            this.hash.put(variable, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getVariable(String variable) {
        try {
            return this.hash.get(variable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean setHandler(TypeHandler newhandler) {
        try {
            this.handlers.put(newhandler.getType(), newhandler);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void read(InputStream istream) throws IOException {
        String line;
        InflaterInputStream gstream;
        int blocksize = 4096;
        byte[] buffer = new byte[blocksize];
        if (this.clearBeforeRead) {
            this.clear();
        }
        istream = new BufferedInputStream(istream, blocksize);
        istream.mark(Integer.MAX_VALUE);
        int count = istream.read(buffer);
        if (count == 0) {
            return;
        }
        String datatype = "UNCOMPRESSED";
        try {
            gstream = new GZIPInputStream(new ByteArrayInputStream(buffer));
            if (((GZIPInputStream)gstream).read(buffer, 0, count) > 0) {
                datatype = "GZIPPED";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (datatype.equals("UNCOMPRESSED")) {
            try {
                gstream = new InflaterInputStream(new ByteArrayInputStream(buffer));
                if (gstream.read(buffer, 0, count) > 0) {
                    datatype = "DEFLATED";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        istream.reset();
        LineNumberReader reader = null;
        String charset = "ISO-8859-1";
        this.encoding = "ISO-8859-1 Unicode Escapes";
        if (datatype.equals("UNCOMPRESSED")) {
            reader = new LineNumberReader(new InputStreamReader(istream, charset));
        } else if (datatype.equals("GZIPPED")) {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new GZIPInputStream(istream), charset));
        } else if (datatype.equals("DEFLATED")) {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new InflaterInputStream(istream), charset));
        }
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String candidate = line.replaceFirst("(^[\\s]*#[\\!][\\s]*encoding[\\s]*=)", "");
            if (line.length() > candidate.length()) {
                if ("ISO-8859-1 Unicode Escapes".equals(candidate = candidate.trim())) break;
                charset = candidate;
                this.setEncoding(candidate);
                break;
            }
            String comment = line.replaceFirst("(^[\\s]*#)", "");
            if (line.length() != comment.length()) continue;
            break;
        }
        istream.reset();
        if (datatype.equals("UNCOMPRESSED")) {
            reader = new LineNumberReader(new InputStreamReader(istream, charset));
            this.setCompression("UNCOMPRESSED");
        } else if (datatype.equals("GZIPPED")) {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new GZIPInputStream(istream), charset));
            this.setCompression("GZIPPED");
        } else if (datatype.equals("DEFLATED")) {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new InflaterInputStream(istream), charset));
            this.setCompression("DEFLATED");
        }
        boolean defaultEncoding = this.encoding.equals("ISO-8859-1 Unicode Escapes");
        String separator = System.getProperty("line.separator");
        StringBuilder comments = new StringBuilder(0);
        boolean inheader = true;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String comment = line.replaceFirst("(^[\\s]*#)", "");
            if (line.length() > comment.length() && inheader) {
                String candidate = line.replaceFirst("(^[\\s]*#[\\!][\\s]*encoding[\\s]*=)", "");
                if (line.length() != candidate.length()) continue;
                if (comments.length() > 0) {
                    comments.append(separator);
                }
                comment = comment.replaceFirst("(^[ ])", "");
                comments.append(comment);
                continue;
            }
            inheader = false;
            String converted = defaultEncoding ? Configuration.readConvertProperties(line) : Configuration.readConvert(line);
            int pos = converted.indexOf(61);
            if (pos <= -1) continue;
            String variable = converted.substring(0, pos);
            String value = converted.substring(pos + 1);
            this.setVariable(variable, value);
        }
        this.setComment(comments.toString());
    }

    public static String readConvertProperties(String theString) {
        int len = theString.length();
        int bufLen = len << 1;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar == '\\' && x + 1 < len) {
                char lookahead = theString.charAt(x + 1);
                switch (lookahead) {
                    case ' ': {
                        outBuffer.append(' ');
                        ++x;
                        break;
                    }
                    case 't': {
                        outBuffer.append('\t');
                        ++x;
                        break;
                    }
                    case 'n': {
                        outBuffer.append('\n');
                        ++x;
                        break;
                    }
                    case 'r': {
                        outBuffer.append('\r');
                        ++x;
                        break;
                    }
                    case 'f': {
                        outBuffer.append('\f');
                        ++x;
                        break;
                    }
                    case '=': {
                        outBuffer.append('=');
                        ++x;
                        break;
                    }
                    case ':': {
                        outBuffer.append(':');
                        ++x;
                        break;
                    }
                    case '#': {
                        outBuffer.append('#');
                        ++x;
                        break;
                    }
                    case '!': {
                        outBuffer.append('!');
                        ++x;
                        break;
                    }
                    case 'u': {
                        try {
                            String hex = theString.substring(x + 2, x + 6);
                            int intval = Integer.valueOf(hex, 16);
                            outBuffer.append((char)intval);
                            x += 5;
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        }
                    }
                    case '\\': {
                        outBuffer.append('\\');
                        ++x;
                        break;
                    }
                    default: {
                        outBuffer.append(aChar);
                        break;
                    }
                }
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static String readConvert(String theString) {
        int len = theString.length();
        int bufLen = len << 1;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar == '\\' && x + 1 < len) {
                char lookahead = theString.charAt(x + 1);
                switch (lookahead) {
                    case '=': {
                        outBuffer.append('=');
                        ++x;
                        break;
                    }
                    case 'r': {
                        outBuffer.append('\r');
                        ++x;
                        break;
                    }
                    case 'n': {
                        outBuffer.append('\n');
                        ++x;
                        break;
                    }
                    case '#': {
                        outBuffer.append('#');
                        ++x;
                        break;
                    }
                    case '\\': {
                        outBuffer.append('\\');
                        ++x;
                        break;
                    }
                    default: {
                        outBuffer.append(aChar);
                        break;
                    }
                }
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    public synchronized void write(OutputStream ostream) throws IOException {
        String newline = System.getProperty("line.separator");
        if (this.compression.equals("GZIPPED")) {
            ostream = new GZIPOutputStream(ostream);
        } else if (this.compression.equals("DEFLATED")) {
            ostream = new DeflaterOutputStream(ostream);
        }
        boolean defaultEncoding = this.encoding.equals("ISO-8859-1 Unicode Escapes");
        String charset = defaultEncoding ? "ISO-8859-1" : this.encoding;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ostream, charset));
        if (this.comment != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.comment, "\n\r");
            while (tokenizer.hasMoreTokens()) {
                writer.write("# " + tokenizer.nextToken() + newline);
            }
            writer.write(newline);
        }
        writer.write("#! encoding=" + this.encoding + newline);
        writer.write(newline);
        if (this.sorting) {
            Vector<String> sorter = new Vector<String>(0);
            Enumeration<String> en = this.hash.keys();
            while (en.hasMoreElements()) {
                sorter.addElement(en.nextElement());
            }
            Collections.sort(sorter);
            int size = sorter.size();
            for (int i = 0; i < size; ++i) {
                String key = (String)sorter.elementAt(i);
                String val = this.hash.get(key);
                key = defaultEncoding ? Configuration.writeConvertProperties(key, true) : Configuration.writeConvert(key);
                val = defaultEncoding ? Configuration.writeConvertProperties(val, false) : Configuration.writeConvert(val);
                writer.write(key + '=' + val + newline);
            }
            sorter.removeAllElements();
        } else {
            Enumeration<String> en = this.hash.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String val = this.hash.get(key);
                key = defaultEncoding ? Configuration.writeConvertProperties(key, true) : Configuration.writeConvert(key);
                val = defaultEncoding ? Configuration.writeConvertProperties(val, false) : Configuration.writeConvert(val);
                writer.write(key + '=' + val + newline);
            }
        }
        writer.flush();
        if (ostream instanceof GZIPOutputStream) {
            ((GZIPOutputStream)ostream).finish();
        } else if (ostream instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)ostream).finish();
        }
    }

    private static String writeConvertProperties(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len << 1;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Integer.toHexString(aChar >> 12 & 0xF).toUpperCase());
                        outBuffer.append(Integer.toHexString(aChar >> 8 & 0xF).toUpperCase());
                        outBuffer.append(Integer.toHexString(aChar >> 4 & 0xF).toUpperCase());
                        outBuffer.append(Integer.toHexString(aChar & 0xF).toUpperCase());
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static String writeConvert(String theString) {
        int len = theString.length();
        int bufLen = len << 1;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block7: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block7;
                }
                case '=': {
                    outBuffer.append("\\=");
                    continue block7;
                }
                case '#': {
                    outBuffer.append("\\#");
                    continue block7;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public boolean setInt(String variable, int value) {
        return this.setVariable(variable, Integer.toString(value));
    }

    public boolean setBoolean(String variable, boolean value) {
        return this.setVariable(variable, String.valueOf(value));
    }

    public synchronized boolean setObject(String variable, Object value) {
        try {
            TypeHandler handler = this.handlers.get(value.getClass().getName());
            return this.setVariable(variable, handler.serialize(value));
        }
        catch (Exception e) {
            if (value == null) {
                return this.setVariable(variable, "null");
            }
            throw new IllegalArgumentException();
        }
    }

    public boolean isTypeSupported(Class clazz) {
        String[] types = this.getSupportedTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedTypes() {
        String[] types = new String[this.handlers.size()];
        int index = 0;
        Enumeration<String> en = this.handlers.keys();
        while (en.hasMoreElements()) {
            types[index] = en.nextElement();
            ++index;
        }
        return types;
    }

    public int getInt(String variable) throws IllegalArgumentException {
        try {
            return Integer.parseInt(this.hash.get(variable));
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public int getInt(String variable, int fallback) {
        try {
            return Integer.parseInt(this.hash.get(variable));
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public boolean getBoolean(String variable, boolean fallback) {
        try {
            return this.hash.get(variable).equals("true");
        }
        catch (Exception exception) {
            return fallback;
        }
    }

    public synchronized Object getObject(String variable, String type) throws IllegalArgumentException {
        try {
            TypeHandler handler = this.handlers.get(type);
            String value = this.getVariable(variable);
            if (value != null && value.equals("null")) {
                return null;
            }
            return handler.deserialize(value);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public Object getObject(String variable, String type, Object fallback) {
        try {
            TypeHandler handler = this.handlers.get(type);
            String value = this.getVariable(variable);
            if (value != null && value.equals("null")) {
                return null;
            }
            return handler.deserialize(value);
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public synchronized Object getObject(String variable, Class clazz) throws IllegalArgumentException {
        return this.getObject(variable, clazz.getName());
    }

    public Object getObject(String variable, Class clazz, Object fallback) {
        return this.getObject(variable, clazz.getName(), fallback);
    }

    public Hashtable<String, String> getCache() {
        return this.hash;
    }

    public void setCompression(String compression) {
        if (!(compression.equals("UNCOMPRESSED") || compression.equals("GZIPPED") || compression.equals("DEFLATED"))) {
            throw new IllegalArgumentException();
        }
        this.compression = compression;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding.equals("ISO-8859-1 Unicode Escapes")) {
            this.encoding = "ISO-8859-1 Unicode Escapes";
        } else if ("Test".getBytes(encoding) != null) {
            this.encoding = encoding;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean contains(String variable) {
        try {
            return this.hash.containsKey(variable);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean remove(String variable) {
        try {
            this.hash.remove(variable);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration checked = (Configuration)obj;
        if (this.hash.size() != checked.getCache().size()) {
            return false;
        }
        Enumeration<String> en = this.hash.keys();
        while (en.hasMoreElements()) {
            String checked_value;
            String variable = en.nextElement();
            String value = this.getVariable(variable);
            if (value.equals(checked_value = checked.getVariable(variable))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.hash.isEmpty();
    }
}

