/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.config;

import com.dropbox.core.DbxEntry;
import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.lang.ReflectionUtils;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.vfs2.FileSystemOptions;

public class ConfigUtils {
    public static void copyVariables(Configuration from, Configuration to) {
        ConfigUtils.copyVariables(from, to, null);
    }

    public static void copyVariables(Configuration from, Configuration to, String prefix) {
        Hashtable<String, String> cache = from.getCache();
        Enumeration<String> en = cache.keys();
        while (en.hasMoreElements()) {
            String variable = en.nextElement();
            String value = cache.get(variable);
            to.setVariable(prefix != null ? prefix + variable : variable, value);
        }
    }

    public static FileSystemOptions convertToFileSystemOptions(Configuration config) {
        FileSystemOptions options = new FileSystemOptions();
        try {
            Method method_setOption = options.getClass().getDeclaredMethod("setOption", Class.class, String.class, Object.class);
            method_setOption.setAccessible(true);
            Hashtable<String, String> cache = config.getCache();
            Enumeration<String> en = cache.keys();
            while (en.hasMoreElements()) {
                try {
                    Object value;
                    String fullkey = en.nextElement();
                    if (!fullkey.endsWith(".name")) continue;
                    String name = cache.get(fullkey);
                    String type = cache.get(name + ".type");
                    Object object = value = type == null || type.equals("null") ? null : config.getObject(name + ".value", Class.forName(type));
                    String classtype = cache.get(name + ".class");
                    if (classtype == null || classtype.equals("null")) continue;
                    Class<?> clazz = Class.forName(classtype);
                    method_setOption.invoke((Object)options, clazz, name, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public static Configuration convertFromFileSystemOptions(FileSystemOptions options) {
        Configuration config = new Configuration();
        try {
            Map map = (Map)ReflectionUtils.getDeclaredField(options, "options");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Object key = iterator.next();
                    String name = (String)ReflectionUtils.getDeclaredField(key, "name");
                    config.setObject(name + ".name", name);
                    Object value = map.get(key);
                    if (value != null && !config.isTypeSupported(value.getClass())) {
                        CommonsSettings.logMessage(Level.WARNING, "File system option type " + value.getClass().getName() + " not supported!");
                        continue;
                    }
                    config.setObject(name + ".type", value != null ? value.getClass().getName() : "null");
                    config.setObject(name + ".value", value != null ? String.valueOf(value) : "null");
                    Class clazz = (Class)ReflectionUtils.getDeclaredField(key, "fileSystemClass");
                    config.setObject(name + ".class", clazz.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public static Properties convertFromDbxEntry(DbxEntry entry) {
        Properties props = new Properties();
        try {
            String line;
            StringBuilder builder = new StringBuilder(0);
            entry.toStringMultiline(builder, 0, true);
            LineNumberReader reader = new LineNumberReader(new StringReader(builder.toString()));
            while ((line = reader.readLine()) != null) {
                String converted;
                int pos;
                if ((line = line.trim()).isEmpty() || (pos = (converted = ConfigUtils.readConvert(line)).indexOf(61)) <= -1) continue;
                String variable = converted.substring(0, pos).trim();
                String value = converted.substring(pos + 1).trim().replaceAll("(^[\"]|[\"]$)", "");
                props.setProperty(variable, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    private static String readConvert(String theString) {
        int len = theString.length();
        int bufLen = len << 1;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar == '\\' && x + 1 < len) {
                char lookahead = theString.charAt(x + 1);
                switch (lookahead) {
                    case '=': {
                        outBuffer.append('=');
                        ++x;
                        break;
                    }
                    case 'r': {
                        outBuffer.append('\r');
                        ++x;
                        break;
                    }
                    case 'n': {
                        outBuffer.append('\n');
                        ++x;
                        break;
                    }
                    case '#': {
                        outBuffer.append('#');
                        ++x;
                        break;
                    }
                    case '\\': {
                        outBuffer.append('\\');
                        ++x;
                        break;
                    }
                    default: {
                        outBuffer.append(aChar);
                        break;
                    }
                }
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }
}

