/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.s3.S3FileObject;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class S3RandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    protected S3FileObject fileObject = null;
    protected DataInputStream dataInputStream = null;
    protected InputStream s3InputStream = null;

    S3RandomAccessContent(S3FileObject fileobject, RandomAccessMode mode) {
        super(mode);
        if (fileobject == null) {
            throw new NullPointerException();
        }
        this.fileObject = fileobject;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "RANDOM_ACCESS_INVALID_POSITION_ERROR");
            throw new FileSystemException(text, new Object[]{pos});
        }
        if (this.dataInputStream != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dataInputStream != null) {
            return this.dataInputStream;
        }
        this.s3InputStream = this.fileObject.getInputStream();
        int i = 0;
        while ((long)i < this.filePointer) {
            this.s3InputStream.read();
            ++i;
        }
        this.dataInputStream = new DataInputStream(new FilterInputStream(this.s3InputStream){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++S3RandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    S3RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    S3RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public void close() throws IOException {
                S3RandomAccessContent.this.close();
            }
        });
        return this.dataInputStream;
    }

    public void close() throws IOException {
        if (this.dataInputStream != null) {
            this.s3InputStream.close();
            DataInputStream oldstream = this.dataInputStream;
            this.dataInputStream = null;
            oldstream.close();
            this.s3InputStream = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

