/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.lf.commons.i18n.Localize;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.s3.S3FileSystem;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;

public class S3FileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static S3FileSystemConfigBuilder sharedInstance;
    public static final String DISPLAY_NAME;
    public static final String ACCESS_KEY_ID;
    public static final String SECRET_KEY;
    public static final String BUCKET_NAME;
    protected VFSLib vfsLib = null;

    @Localize(value={})
    public S3FileSystemConfigBuilder() {
        this(null);
    }

    public S3FileSystemConfigBuilder(VFSLib vfslib) {
        super("s3.");
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
    }

    public static synchronized S3FileSystemConfigBuilder getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new S3FileSystemConfigBuilder();
        }
        return sharedInstance;
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return S3FileSystem.class;
    }

    public void setAccountDisplayName(FileSystemOptions options, String name) {
        super.setParam(options, DISPLAY_NAME, (Object)name);
    }

    public String getAccountDisplayName(FileSystemOptions options) {
        return (String)super.getParam(options, DISPLAY_NAME);
    }

    public void setAccessKeyID(FileSystemOptions options, String token) {
        super.setParam(options, ACCESS_KEY_ID, (Object)token);
    }

    public String getAccessKeyID(FileSystemOptions options) {
        return (String)super.getParam(options, ACCESS_KEY_ID);
    }

    public void setSecretKey(FileSystemOptions options, String token) {
        super.setParam(options, SECRET_KEY, (Object)token);
    }

    public String getSecretKey(FileSystemOptions options) {
        return (String)super.getParam(options, SECRET_KEY);
    }

    public void setBucketName(FileSystemOptions options, String name) {
        super.setParam(options, BUCKET_NAME, (Object)name);
    }

    public String getBucketName(FileSystemOptions options) {
        return (String)super.getParam(options, BUCKET_NAME);
    }

    static {
        DISPLAY_NAME = S3FileSystemConfigBuilder.class.getName() + ".DISPLAY_NAME";
        ACCESS_KEY_ID = S3FileSystemConfigBuilder.class.getName() + ".ACCESS_KEY_ID";
        SECRET_KEY = S3FileSystemConfigBuilder.class.getName() + ".SECRET_KEY";
        BUCKET_NAME = S3FileSystemConfigBuilder.class.getName() + ".BUCKET_NAME";
    }
}

