/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.lf.vfslib.VFSLib;
import com.lf.vfslib.s3.S3ClientWrapper;
import com.lf.vfslib.s3.S3FileObject;
import com.lf.vfslib.s3.S3FileProvider;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;

public class S3FileSystem
extends AbstractFileSystem
implements FileSystem {
    protected VFSLib vfsLib = null;
    protected S3FileProvider provider = null;

    protected S3FileSystem(GenericFileName rootName, FileSystemOptions options, VFSLib vfslib, S3FileProvider provider) {
        super((FileName)rootName, null, options);
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
    }

    protected S3ClientWrapper getClient() throws IOException {
        return S3ClientWrapper.getS3ClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions(), this.vfsLib, this.provider);
    }

    protected void putClient(S3ClientWrapper client) {
        S3ClientWrapper.unlockS3ClientWrapper(client);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(S3FileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new S3FileObject(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public VFSLib getVFSLib() {
        return this.vfsLib;
    }
}

