/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.lf.commons.lang.JavaUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.s3.S3ClientWrapper;
import com.lf.vfslib.s3.S3FileNameParser;
import com.lf.vfslib.s3.S3FileSystem;
import com.lf.vfslib.s3.S3FileSystemConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;

public final class S3FileProvider
extends AbstractOriginatingFileProvider {
    private VFSLib vfsLib = null;
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.RANDOM_ACCESS_READ, Capability.READ_CONTENT, Capability.RENAME, Capability.SET_LAST_MODIFIED_FILE, Capability.URI, Capability.WRITE_CONTENT));

    public S3FileProvider() throws InstantiationException {
        throw new InstantiationException("Do not use this constructor!");
    }

    public S3FileProvider(VFSLib vfslib) {
        if (vfslib == null) {
            throw new NullPointerException();
        }
        if (!JavaUtils.isMethodCalled(VFSLib.class, "addProviderAmazonS3")) {
            VFSLibSettings.logMessage("VFSLIB-0025", Level.SEVERE);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0025"));
        }
        try {
            Field field = VFSLib.class.getDeclaredField("licenseManager");
            field.setAccessible(true);
            Object obj = field.get(vfslib);
            Method method = obj.getClass().getDeclaredMethod("checkLicense", Object.class);
            method.setAccessible(true);
            method.invoke(obj, new Object[]{this});
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        this.vfsLib = vfslib;
        this.setFileNameParser(S3FileNameParser.getSharedInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions options) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        S3ClientWrapper client = S3ClientWrapper.getS3ClientWrapper(rootName, options, this.vfsLib, this);
        S3ClientWrapper.unlockS3ClientWrapper(client);
        return new S3FileSystem(rootName, options, this.vfsLib, this);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return S3FileSystemConfigBuilder.getSharedInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

