/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.lf.commons.lang.JavaUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.gdrive.GDriveClientWrapper;
import com.lf.vfslib.s3.S3ClientWrapper;
import com.lf.vfslib.s3.S3FileSystem;
import com.lf.vfslib.s3.S3FileSystemConfigBuilder;
import com.lf.vfslib.s3.S3RandomAccessContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class S3FileObject
extends AbstractFileObject
implements FileObject {
    protected final S3FileSystem fileSystem;
    protected String relPath = null;
    protected boolean inRefresh = false;
    protected Bucket s3Bucket = null;
    protected S3Object s3Object = null;

    public S3FileObject(AbstractFileName name, S3FileSystem filesystem) throws FileSystemException {
        super(name, (AbstractFileSystem)filesystem);
        this.fileSystem = filesystem;
        this.relPath = UriParser.decode((String)filesystem.getRootName().getRelativeName((FileName)name));
        if (this.relPath.equals(".") || this.relPath.equals("/")) {
            this.relPath = "";
        }
        this.relPath = this.relPath.replaceAll("^([/]+|[/]+)$", "");
    }

    private Bucket getS3Bucket() {
        if (this.s3Bucket == null) {
            try {
                FileSystemOptions fsoptions = this.fileSystem.getFileSystemOptions();
                String name = S3FileSystemConfigBuilder.getSharedInstance().getBucketName(fsoptions);
                this.s3Bucket = new Bucket(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.s3Bucket;
    }

    protected void doDetach() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected FileType doGetType() throws Exception {
        this.statSelf();
        if (this.relPath.endsWith("/")) {
            return FileType.FOLDER;
        }
        if (this.s3Object != null) {
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statSelf() throws Exception {
        block10: {
            this.getS3Bucket();
            if (this.s3Object != null || this.relPath.endsWith("/")) {
                return;
            }
            S3ClientWrapper client = this.fileSystem.getClient();
            try {
                if (this.relPath.equals("")) {
                    this.relPath = "/";
                    this.s3Object = null;
                    break block10;
                }
                this.s3Object = null;
                try {
                    this.s3Object = client.s3Client.getObject(this.s3Bucket.getName(), this.relPath);
                }
                catch (Exception e) {
                    ListObjectsRequest request = new ListObjectsRequest();
                    request.setBucketName(this.s3Bucket.getName());
                    request.setDelimiter("/");
                    int pos = this.relPath.lastIndexOf(47);
                    String parentpath = pos != -1 ? this.relPath.substring(0, pos) + "/" : "";
                    request.setPrefix(parentpath);
                    String folderpath = this.relPath + "/";
                    ObjectListing listing = client.s3Client.listObjects(request);
                    for (String folder : listing.getCommonPrefixes()) {
                        if (!folder.equals(folderpath)) continue;
                        this.relPath = folderpath;
                        this.s3Object = null;
                    }
                    break block10;
                }
                {
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.s3Object = null;
            }
            finally {
                this.fileSystem.putClient(client);
            }
        }
    }

    protected void onChange() throws Exception {
        this.s3Object = null;
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        this.statSelf();
        S3ClientWrapper client = this.fileSystem.getClient();
        try {
            String folder = this.relPath.endsWith("/") ? this.relPath : this.relPath + "/";
            PutObjectRequest request = new PutObjectRequest(this.s3Bucket.getName(), folder, (InputStream)new ByteArrayInputStream(new byte[0]), null);
            PutObjectResult result = client.s3Client.putObject(request);
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        this.statSelf();
        try {
            return this.s3Object.getObjectMetadata().getLastModified().getTime();
        }
        catch (Exception e) {
            throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_MOD_TIME_ERROR"));
        }
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.statSelf();
        try {
            this.s3Object.getObjectMetadata().setLastModified(new Date(modtime));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileSystemException(VFSLibSettings.getUserText(GDriveClientWrapper.class, "SET_MOD_TIME_ERROR"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        this.statSelf();
        S3ClientWrapper client = this.fileSystem.getClient();
        try {
            client.s3Client.deleteObject(this.s3Bucket.getName(), this.relPath);
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        block4: {
            this.statSelf();
            S3ClientWrapper client = this.fileSystem.getClient();
            try {
                if (this.getType().equals((Object)FileType.FILE)) {
                    client.s3Client.copyObject(this.s3Bucket.getName(), this.relPath, this.s3Bucket.getName(), ((S3FileObject)newfile).relPath);
                    client.s3Client.deleteObject(this.s3Bucket.getName(), this.relPath);
                    break block4;
                }
                throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "RENAME_ERROR"));
            }
            finally {
                this.fileSystem.putClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileObject[] array = null;
        S3ClientWrapper client = this.fileSystem.getClient();
        FileSystemManager fsmanager = this.getFileSystem().getFileSystemManager();
        this.statSelf();
        try {
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.s3Bucket.getName());
            request.setDelimiter("/");
            request.setPrefix(this.relPath.equals("/") ? "" : this.relPath);
            ObjectListing listing = client.s3Client.listObjects(request);
            List folders = listing.getCommonPrefixes();
            int size = folders.size();
            array = new FileObject[size];
            for (int i = 0; i < size; ++i) {
                String folder = (String)folders.get(i);
                String[] list = folder.split("([/])");
                folder = list[list.length - 1];
                array[i] = this.fileSystem.resolveFile(fsmanager.resolveName(this.getName(), UriParser.encode((String)folder), NameScope.CHILD));
                if (((S3FileObject)array[i]).relPath.endsWith("/")) continue;
                ((S3FileObject)array[i]).relPath = ((S3FileObject)array[i]).relPath + "/";
            }
            List children = listing.getObjectSummaries();
            size = children.size();
            for (int i = 0; i < size; ++i) {
                S3ObjectSummary summary = (S3ObjectSummary)children.get(i);
                if (summary.getKey().equals(this.relPath)) continue;
                String file = summary.getKey();
                String[] list = file.split("([/])");
                file = list[list.length - 1];
                FileObject fileobj = this.fileSystem.resolveFile(fsmanager.resolveName(this.getName(), UriParser.encode((String)file), NameScope.CHILD));
                array = (FileObject[])JavaUtils.addToArray(array, fileobj);
            }
        }
        finally {
            this.fileSystem.putClient(client);
        }
        return array;
    }

    protected String[] doListChildren() throws Exception {
        FileObject[] childs = this.doListChildrenResolved();
        String[] result = new String[childs.length];
        for (int i = 0; i < childs.length; ++i) {
            result[i] = String.valueOf(childs[i]);
        }
        return result;
    }

    protected long doGetContentSize() throws Exception {
        this.statSelf();
        try {
            return this.s3Object.getObjectMetadata().getContentLength();
        }
        catch (Exception e) {
            throw new FileSystemException(VFSLibSettings.getUserText(DbxClientWrapper.class, "UNKNOWN_SIZE_ERROR"));
        }
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new S3RandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        this.statSelf();
        if (!this.getType().hasContent()) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "READ_NOT_FILE_ERROR");
            throw new FileSystemException(text, (Object)this.getName());
        }
        S3ClientWrapper client = this.fileSystem.getClient();
        S3FileSystem s3FileSystem = this.fileSystem;
        synchronized (s3FileSystem) {
            S3InputStream s3InputStream = new S3InputStream(client, (InputStream)this.s3Object.getObjectContent());
            return s3InputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        this.statSelf();
        final S3ClientWrapper client = this.fileSystem.getClient();
        S3FileSystem s3FileSystem = this.fileSystem;
        synchronized (s3FileSystem) {
            PipedOutputStream postream = new PipedOutputStream();
            PipedInputStream pistream = new PipedInputStream(postream);
            final PutObjectRequest request = new PutObjectRequest(this.s3Bucket.getName(), this.relPath, (InputStream)pistream, null);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PutObjectResult result = client.s3Client.putObject(request);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, "[vfslib] Put Object Requester");
            thread.setPriority(1);
            thread.start();
            S3OutputStream s3OutputStream = new S3OutputStream(client, postream, thread);
            return s3OutputStream;
        }
    }

    public VFSLib getVFSLib() {
        return this.fileSystem.getVFSLib();
    }

    private class S3OutputStream
    extends MonitorOutputStream {
        private S3ClientWrapper client;
        private Thread requester;

        public S3OutputStream(S3ClientWrapper client, OutputStream out, Thread requester) {
            super(out);
            this.client = null;
            this.requester = null;
            this.client = client;
            this.requester = requester;
        }

        protected void onClose() throws IOException {
            try {
                this.requester.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            S3FileObject.this.fileSystem.putClient(this.client);
        }
    }

    private class S3InputStream
    extends MonitorInputStream {
        private S3ClientWrapper client;

        public S3InputStream(S3ClientWrapper client, InputStream in) {
            super(in);
            this.client = null;
            this.client = client;
        }

        protected void onClose() throws IOException {
            S3FileObject.this.fileSystem.putClient(this.client);
        }
    }
}

