/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.s3;

import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.lf.commons.i18n.Localize;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.net.ClientPool;
import com.lf.vfslib.net.ClientWrapper;
import com.lf.vfslib.s3.S3ClientFactory;
import com.lf.vfslib.s3.S3FileProvider;
import com.lf.vfslib.s3.S3FileSystemConfigBuilder;
import java.beans.Beans;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;

public class S3ClientWrapper
implements ClientWrapper {
    protected GenericFileName root = null;
    protected FileSystemOptions fileSystemOptions = null;
    protected VFSLib vfsLib = null;
    protected S3FileProvider provider = null;
    protected AmazonS3Client s3Client = null;

    @Localize(value={@Localize.Variable(name="CONNECT_ERROR", value="Could not connect to Amazon S3 server at %server%")})
    public S3ClientWrapper() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    S3ClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, S3FileProvider provider) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = options;
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
        this.createClient();
    }

    protected void createClient() throws FileSystemException {
        try {
            S3FileSystemConfigBuilder builder = S3FileSystemConfigBuilder.getSharedInstance();
            String accesskeyid = builder.getAccessKeyID(this.fileSystemOptions);
            String secretkey = builder.getSecretKey(this.fileSystemOptions);
            BasicAWSCredentials credentials = new BasicAWSCredentials(accesskeyid, secretkey);
            this.s3Client = S3ClientFactory.createClient(this.root, this.fileSystemOptions, credentials, this.vfsLib);
        }
        catch (Exception e) {
            String text = VFSLibSettings.getUserText(S3ClientWrapper.class, "CONNECT_ERROR");
            throw new FileSystemException(text.replaceAll("(%server%)", String.valueOf(this.root)), (Object)this.root, (Throwable)e);
        }
    }

    protected AmazonS3Client getClient() {
        return this.s3Client;
    }

    @Override
    public boolean disconnectClient() {
        return true;
    }

    @Override
    public String getURLID() {
        return this.toString();
    }

    public static S3ClientWrapper getS3ClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, S3FileProvider provider) throws FileSystemException {
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        ClientPool pool = ClientPool.getSharedInstance();
        try {
            ClientWrapper recycled = pool.getFreeClient(S3ClientWrapper.getClientURLID(root, options, vfslib));
            if (recycled != null) {
                return (S3ClientWrapper)recycled;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        S3ClientWrapper wrapper = new S3ClientWrapper(root, options, vfslib, provider);
        pool.addClient(wrapper);
        return wrapper;
    }

    public static void unlockS3ClientWrapper(S3ClientWrapper wrapper) {
        ClientPool.getSharedInstance().unlockClient(wrapper);
    }

    public String toString() {
        return S3ClientWrapper.getClientURLID(this.root, this.fileSystemOptions, this.vfsLib);
    }

    public static String getClientURLID(GenericFileName root, FileSystemOptions options, VFSLib vfslib) {
        S3FileSystemConfigBuilder builder;
        String username;
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        if ((username = (builder = S3FileSystemConfigBuilder.getSharedInstance()).getAccountDisplayName(options)) == null) {
            username = "anonymous";
        }
        return vfslib.getSchemeAmazonS3() + "://" + username + '@' + root.getHostName();
    }
}

