/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.net;

import com.lf.commons.config.ConfigUtils;
import com.lf.commons.config.Configuration;
import com.lf.commons.i18n.Localize;
import com.lf.commons.lang.JavaUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxFileSystemConfigBuilder;
import com.lf.vfslib.gdrive.GDriveFileSystemConfigBuilder;
import com.lf.vfslib.net.VFSFileSystemManager;
import com.lf.vfslib.net.VFSURI;
import com.lf.vfslib.net.VFSUtils;
import com.lf.vfslib.s3.S3FileSystemConfigBuilder;
import java.beans.Beans;
import java.util.UUID;
import java.util.Vector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public class VFSConnection {
    public static final String VAR_CONNECTION_ID = "VAR_CONNECTION_ID";
    public static final String VAR_CONNECTION_NAME = "VAR_CONNECTION_NAME";
    public static final String VAR_PROTOCOL = "VAR_PROTOCOL";
    public static final String VAR_READONLY = "VAR_READONLY";
    public static final String VAR_EXPERT_MAX_WAIT = "VAR_EXPERT_MAX_WAIT";
    public static final String VAR_EXPERT_MAX_WAIT_SECONDS = "VAR_EXPERT_MAX_WAIT_SECONDS";
    public static final String VAR_EXPERT_KEEP_ALIVE = "VAR_EXPERT_KEEP_ALIVE";
    public static final String VAR_EXPERT_KEEP_ALIVE_SECONDS = "VAR_EXPERT_KEEP_ALIVE_SECONDS";
    public static final String VAR_EXPERT_KEEP_ALIVE_PING = "VAR_EXPERT_KEEP_ALIVE_PING";
    public static final String VAR_EXPERT_KEEP_ALIVE_RESOLVE = "VAR_EXPERT_KEEP_ALIVE_RESOLVE";
    public static final String VAR_EXPERT_DISPLAY_BEFORE = "VAR_EXPERT_DISPLAY_BEFORE";
    public static final String VAR_EXPERT_ENCODING = "VAR_EXPERT_ENCODING";
    public static final String PARAM_HOST = "PARAM_HOST";
    public static final String PARAM_PORT = "PARAM_PORT";
    public static final String PARAM_PATH = "PARAM_PATH";
    public static final String PARAM_USER = "PARAM_USER";
    public static final String PARAM_USER_PASSWORD = "PARAM_USER_PWD";
    public static final String PARAM_SAVE_PASSWORD = "PARAM_SAVE_PWD";
    protected Configuration config = null;
    protected VFSFileSystemManager vfsManager = null;
    protected FileSystemOptions options = null;

    @Localize(value={@Localize.Variable(name="USER_NOT_UNIQUE", value="User must be unique for all %scheme% connections"), @Localize.Variable(name="INVALID_EMPTY_TOKEN", value="Access token or secret key must not be empty (required)"), @Localize.Variable(name="INVALID_CONNECTION", value="Connection is invalid"), @Localize.Variable(name="NAME_NOT_UNIQUE", value="Connection name must be unique")})
    public VFSConnection() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public VFSConnection(VFSFileSystemManager vfsmanager, String id) {
        if (vfsmanager == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        this.vfsManager = vfsmanager;
        this.config = new Configuration();
        this.options = new FileSystemOptions();
        this.config.setObject(VAR_CONNECTION_ID, id);
        this.config.setObject(VAR_CONNECTION_NAME, "");
        this.config.setObject(VAR_PROTOCOL, "");
        this.config.setBoolean(VAR_READONLY, false);
        this.config.setBoolean(VAR_EXPERT_MAX_WAIT, false);
        this.config.setInt(VAR_EXPERT_MAX_WAIT_SECONDS, 30);
        this.config.setBoolean(VAR_EXPERT_KEEP_ALIVE, false);
        this.config.setInt(VAR_EXPERT_KEEP_ALIVE_SECONDS, 60);
        this.config.setBoolean(VAR_EXPERT_KEEP_ALIVE_PING, true);
        this.config.setBoolean(VAR_EXPERT_KEEP_ALIVE_RESOLVE, false);
        this.config.setBoolean(VAR_EXPERT_DISPLAY_BEFORE, false);
        this.config.setObject(VAR_EXPERT_ENCODING, "");
        this.config.setObject(PARAM_HOST, "");
        this.config.setInt(PARAM_PORT, -1);
        this.config.setObject(PARAM_PATH, "");
        this.config.setObject(PARAM_USER, "");
        this.config.setObject(PARAM_USER_PASSWORD, "");
        this.config.setBoolean(PARAM_SAVE_PASSWORD, false);
    }

    public VFSConnection(VFSFileSystemManager vfsmanager, String id, Configuration config, FileSystemOptions options) {
        if (vfsmanager == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        if (config == null) {
            throw new NullPointerException();
        }
        if (options == null) {
            throw new NullPointerException();
        }
        this.vfsManager = vfsmanager;
        this.config = config;
        this.config.setObject(VAR_CONNECTION_ID, id);
        this.options = options;
    }

    public VFSFileSystemManager getFileSystemManager() {
        return this.vfsManager;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.options;
    }

    public void setFileSystemOptions(FileSystemOptions options) {
        this.options = options;
    }

    public boolean hasFileSystemOptions() {
        return VFSUtils.hasFileSystemOptions(this.options);
    }

    public boolean isAvailable() {
        try {
            String[] schemes = this.vfsManager.getSchemes();
            String protocol = this.getProtocol(null);
            return JavaUtils.elementOf(protocol, schemes);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getID(String fallback) {
        return (String)this.config.getObject(VAR_CONNECTION_ID, String.class, (Object)fallback);
    }

    public String getName(String fallback) {
        return (String)this.config.getObject(VAR_CONNECTION_NAME, String.class, (Object)fallback);
    }

    public void setName(String value) {
        if (value != null) {
            this.config.setObject(VAR_CONNECTION_NAME, value);
        } else {
            this.config.remove(VAR_CONNECTION_NAME);
        }
    }

    public String getProtocol(String fallback) {
        return (String)this.config.getObject(VAR_PROTOCOL, String.class, (Object)fallback);
    }

    public void setProtocol(String value) {
        if (value != null) {
            this.config.setObject(VAR_PROTOCOL, value);
        } else {
            this.config.remove(VAR_PROTOCOL);
        }
    }

    public boolean isReadOnly(boolean fallback) {
        return this.config.getBoolean(VAR_READONLY, fallback);
    }

    public void setReadOnly(boolean value) {
        this.config.setBoolean(VAR_READONLY, value);
    }

    public boolean getMaxWait(boolean fallback) {
        return this.config.getBoolean(VAR_EXPERT_MAX_WAIT, fallback);
    }

    public int getMaxWaitSeconds(int fallback) {
        return this.config.getInt(VAR_EXPERT_MAX_WAIT_SECONDS, fallback);
    }

    public boolean getKeepAlive(boolean fallback) {
        return this.config.getBoolean(VAR_EXPERT_KEEP_ALIVE, fallback);
    }

    public int getKeepAliveSeconds(int fallback) {
        return this.config.getInt(VAR_EXPERT_KEEP_ALIVE_SECONDS, fallback);
    }

    public boolean getKeepAlivePing(boolean fallback) {
        return this.config.getBoolean(VAR_EXPERT_KEEP_ALIVE_PING, fallback);
    }

    public boolean getKeepAliveResolve(boolean fallback) {
        return this.config.getBoolean(VAR_EXPERT_KEEP_ALIVE_RESOLVE, fallback);
    }

    public boolean getDisplayBefore(boolean fallback) {
        return this.config.getBoolean(VAR_EXPERT_DISPLAY_BEFORE, fallback);
    }

    public String getEncoding(String fallback) {
        return (String)this.config.getObject(VAR_EXPERT_ENCODING, String.class, (Object)fallback);
    }

    public String getHost(String fallback) {
        return (String)this.config.getObject(PARAM_HOST, String.class, (Object)fallback);
    }

    public int getPort(int fallback) {
        return this.config.getInt(PARAM_PORT, fallback);
    }

    public String getPath(String fallback) {
        return (String)this.config.getObject(PARAM_PATH, String.class, (Object)fallback);
    }

    public String getUser(String fallback) {
        return (String)this.config.getObject(PARAM_USER, String.class, (Object)fallback);
    }

    public void setUser(String user) {
        this.config.setObject(PARAM_USER, user);
    }

    public String getPassword(String fallback) {
        return (String)this.config.getObject(PARAM_USER_PASSWORD, String.class, (Object)fallback);
    }

    public void setPassword(String password) {
        this.config.setObject(PARAM_USER_PASSWORD, password);
    }

    public boolean getSavePassword(boolean save) {
        return this.config.getBoolean(PARAM_SAVE_PASSWORD, save);
    }

    public void setSavePassword(boolean save) {
        this.config.setBoolean(PARAM_SAVE_PASSWORD, save);
    }

    public Configuration getCache() {
        return this.config;
    }

    public boolean isCacheEmpty() {
        return this.config.isEmpty();
    }

    public static String getUniqueConnectionID(Vector<VFSConnection> connections) {
        int size = connections.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = connections.elementAt(i).getID("");
        }
        String id = UUID.randomUUID().toString();
        while (JavaUtils.elementOf(id, ids)) {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    public static VFSConnection createConnection(VFSFileSystemManager vfsmanager, String protocol, String id) {
        if (vfsmanager == null || protocol == null) {
            return null;
        }
        return new VFSConnection(vfsmanager, id);
    }

    public static VFSConnection createConnection(VFSFileSystemManager vfsmanager, String protocol, String id, Configuration config, FileSystemOptions options) {
        if (vfsmanager == null || protocol == null) {
            return null;
        }
        return new VFSConnection(vfsmanager, id, config, options);
    }

    public String toString() {
        return this.getID(null);
    }

    public boolean isConnected() {
        return VFSUtils.available(VFSUtils.getURL(this.vfsManager, this.getRootURI(), this));
    }

    public String getURIHost() {
        try {
            return new VFSURI(this.getURI()).getHost();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String isValid(Vector<VFSConnection> connections) {
        String protocol = this.getProtocol("");
        if (protocol.equals(VFSLib.getSharedInstance().getSchemeDropbox()) || protocol.equals(VFSLib.getSharedInstance().getSchemeGoogleDrive()) || protocol.equals(VFSLib.getSharedInstance().getSchemeAmazonS3())) {
            boolean unique = true;
            if (connections != null && !connections.isEmpty()) {
                unique = this.checkUniqueUser(connections);
            }
            if (!unique) {
                return VFSLibSettings.getUserText(VFSConnection.class, "USER_NOT_UNIQUE", new String[]{"(%scheme%)"}, new String[]{protocol});
            }
            String password = null;
            if (protocol.equals(VFSLib.getSharedInstance().getSchemeDropbox())) {
                password = new DbxFileSystemConfigBuilder().getAccessToken(this.options);
            } else if (protocol.equals(VFSLib.getSharedInstance().getSchemeGoogleDrive())) {
                password = new GDriveFileSystemConfigBuilder().getAccessToken(this.options);
            } else if (protocol.equals(VFSLib.getSharedInstance().getSchemeAmazonS3())) {
                password = new S3FileSystemConfigBuilder().getSecretKey(this.options);
            }
            if (password == null || password.trim().isEmpty()) {
                return VFSLibSettings.getUserText(VFSConnection.class, "INVALID_EMPTY_TOKEN");
            }
        } else {
            boolean unique = true;
            if (connections != null && !connections.isEmpty()) {
                unique = this.checkUniqueName(connections);
            }
            if (!unique) {
                return VFSLibSettings.getUserText(VFSConnection.class, "NAME_NOT_UNIQUE");
            }
            if (this.getURI() == null) {
                return VFSLibSettings.getUserText(VFSConnection.class, "INVALID_CONNECTION");
            }
        }
        return null;
    }

    public boolean isReachable() {
        FileObject target = null;
        try {
            target = this.vfsManager.resolveFile(this.getURI(), this);
        }
        catch (Exception e) {
        }
        catch (Error error) {
            // empty catch block
        }
        return target != null;
    }

    public VFSConnection clone() throws CloneNotSupportedException {
        Configuration temp = new Configuration();
        ConfigUtils.copyVariables(this.config, temp);
        FileSystemOptions options = (FileSystemOptions)this.options.clone();
        return new VFSConnection(this.vfsManager, this.getID(null), temp, options);
    }

    public String getURI() {
        return this.getURI(null, null);
    }

    public String getURI(String username, String password) {
        try {
            String userinfo = null;
            if (username == null) {
                username = this.getUser("");
            }
            if (password == null) {
                password = this.getPassword("");
            }
            if (username.length() >= 1) {
                userinfo = this.getUser("");
                if (password.length() >= 1) {
                    userinfo = userinfo + ':' + password;
                }
            }
            VFSURI uri = new VFSURI(this.getProtocol(null), userinfo, this.getHost(null), this.getPort(-1), this.getPath(null), null, null);
            return uri.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRootURI() {
        return this.getRootURI(null, null);
    }

    public String getRootURI(String username, String password) {
        try {
            String userinfo = null;
            if (username == null) {
                username = this.getUser("");
            }
            if (password == null) {
                password = this.getPassword("");
            }
            if (username.length() >= 1) {
                userinfo = this.getUser("");
                if (password.length() >= 1) {
                    userinfo = userinfo + ':' + password;
                }
            }
            VFSURI uri = new VFSURI(this.getProtocol(null), userinfo, this.getHost(null), this.getPort(-1), null, null, null);
            return uri.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDisplayURI() {
        try {
            String userinfo = null;
            if (this.getUser("").length() >= 1) {
                userinfo = this.getUser("");
            }
            VFSURI uri = new VFSURI(this.getProtocol(null), userinfo, this.getHost(null), this.getPort(-1), this.getPath(null), null, null);
            return uri.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isApplicable(String url, boolean compareuser) {
        try {
            String userinfo = null;
            if (this.getUser("").length() >= 1) {
                userinfo = this.getUser("");
            }
            VFSURI uri = new VFSURI(this.getProtocol(null), compareuser ? userinfo : null, this.getHost(null), this.getPort(-1), null, null, null);
            String displayuri = uri.toString();
            uri = new VFSURI(VFSUtils.getDisplayURIUsernameOnly(url, null));
            uri = new VFSURI(uri.getScheme(), compareuser ? uri.getUserInfo() : null, uri.getHost(), uri.getPort(), null, null, null);
            String paramuri = uri.toString();
            return displayuri.equals(paramuri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystemOptions getDefaultFileSystemOptions(String scheme, String encoding) {
        FileSystemOptions options = new FileSystemOptions();
        try {
            SftpFileSystemConfigBuilder builder;
            if (scheme.equals("sftp")) {
                builder = SftpFileSystemConfigBuilder.getInstance();
                builder.setStrictHostKeyChecking(options, "no");
                builder.setUserDirIsRoot(options, false);
                if (encoding != null && !encoding.trim().isEmpty()) {
                    builder.setControlEncoding(options, encoding);
                }
            } else if (scheme.equals("ftp")) {
                builder = FtpFileSystemConfigBuilder.getInstance();
                builder.setPassiveMode(options, false);
                builder.setUserDirIsRoot(options, false);
                if (encoding != null && !encoding.trim().isEmpty()) {
                    builder.setControlEncoding(options, encoding);
                }
            } else if (scheme.equals("ftps")) {
                builder = FtpsFileSystemConfigBuilder.getInstance();
                builder.setPassiveMode(options, false);
                builder.setUserDirIsRoot(options, false);
                if (encoding != null && !encoding.trim().isEmpty()) {
                    builder.setControlEncoding(options, encoding);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            VFSLib vfslib = VFSLib.getSharedInstance();
            if (scheme.equals(vfslib.getSchemeDropbox())) {
                DbxFileSystemConfigBuilder builder = DbxFileSystemConfigBuilder.getSharedInstance();
                builder.setChunkSize(options, 4096);
                return options;
            }
            if (scheme.equals(vfslib.getSchemeGoogleDrive())) {
                GDriveFileSystemConfigBuilder builder = GDriveFileSystemConfigBuilder.getSharedInstance();
                builder.setUseTrash(options, true);
                return options;
            }
            if (!scheme.equals(vfslib.getSchemeAmazonS3())) return options;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return options;
    }

    public boolean checkUniqueUser(Vector<VFSConnection> connections) {
        if (connections == null) {
            throw new NullPointerException();
        }
        try {
            String username = this.getUser("");
            String protocol = this.getProtocol("");
            for (VFSConnection next : connections) {
                String username2;
                String protocol2;
                if (next == this || next.getID("").equals(this.getID("")) || !protocol.equals(protocol2 = next.getProtocol("")) || !username.equals(username2 = next.getUser(""))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkUniqueName(Vector<VFSConnection> connections) {
        if (connections == null) {
            throw new NullPointerException();
        }
        try {
            String name = this.getName("");
            for (VFSConnection next : connections) {
                String name2;
                if (next == this || next.getID("").equals(this.getID("")) || !name.equals(name2 = next.getName(""))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

