/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.net;

import com.lf.commons.lang.FactoryManager;
import com.lf.commons.lang.JavaUtils;
import com.lf.commons.lang.ManagedFactory;
import com.lf.commons.lang.ManagedObject;
import com.lf.commons.lang.OrderedHashtable;
import com.lf.commons.lang.StringUtils;
import com.lf.commons.lang.strategy.TimeoutStrategy;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.net.ClientWrapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

public class ClientPool
extends ManagedFactory {
    protected static ClientPool sharedInstance;
    protected static TimeoutStrategy STRATEGY;
    protected Hashtable<String, Vector<ManagedObject>> cachePool = null;
    private Vector<ClientWrapper> cacheLocked;
    private Hashtable<ClientWrapper, StackTraceElement[]> cacheLockedBy;

    public ClientPool() {
        FactoryManager.registerFactory(this);
        this.cachePool = new Hashtable(0);
        this.cacheLocked = new Vector(0);
        this.cacheLockedBy = new Hashtable(0);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        Enumeration<String> en = this.cachePool.keys();
        while (en.hasMoreElements()) {
            Vector<ManagedObject> pool = this.cachePool.get(en.nextElement());
            int size = pool.size();
            for (int i = 0; i < size; ++i) {
                ClientWrapper client = (ClientWrapper)pool.elementAt((int)i).object;
                client.disconnectClient();
            }
            pool.removeAllElements();
        }
        this.cachePool.clear();
        this.cacheLocked.removeAllElements();
        this.cacheLockedBy.clear();
    }

    public static synchronized ClientPool getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ClientPool();
        }
        return sharedInstance;
    }

    @Override
    public synchronized Object request(Object id) {
        String url = id instanceof String ? (String)id : String.valueOf(id);
        Vector<ManagedObject> pool = this.cachePool.get(url);
        if (pool != null) {
            int size = pool.size();
            for (int i = 0; i < size; ++i) {
                ManagedObject managed = pool.elementAt(i);
                ClientWrapper client = (ClientWrapper)managed.object;
                if (this.cacheLocked.contains(client)) continue;
                VFSLibSettings.log(Level.CONFIG, "Recycled client " + url + " (" + Integer.toHexString(client.hashCode()) + ") from pool");
                this.cacheLocked.addElement(client);
                this.cacheLockedBy.put(client, Thread.currentThread().getStackTrace());
                managed.lastRequest = new Date();
                ++managed.requestCount;
                return client;
            }
        } else {
            pool = new Vector(0);
            this.cachePool.put(url, pool);
        }
        return null;
    }

    public ClientWrapper getFreeClient(String url) {
        return (ClientWrapper)ClientPool.getSharedInstance().request(url);
    }

    public synchronized void addClient(ClientWrapper client) {
        try {
            String url = client.getURLID();
            Vector<ManagedObject> pool = this.cachePool.get(url);
            if (pool == null) {
                pool = new Vector(0);
                this.cachePool.put(url, pool);
            }
            String clazz = client.getClass().getName();
            ManagedObject managed = new ManagedObject(client, url, clazz, STRATEGY, new Date(), 0, 0);
            pool.addElement(managed);
            this.cacheLocked.addElement(client);
            this.cacheLockedBy.put(client, Thread.currentThread().getStackTrace());
            managed.lastRequest = new Date();
            ++managed.requestCount;
            VFSLibSettings.log(Level.CONFIG, "Added new client " + url + " (" + Integer.toHexString(client.hashCode()) + ") to pool");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean unlockClient(ClientWrapper client) {
        if (client == null) {
            return false;
        }
        try {
            ManagedObject managed = this.findManagedObject(client);
            if (managed != null && this.cacheLocked.contains(client)) {
                this.cacheLocked.removeElement(client);
                this.cacheLockedBy.remove(client);
                managed.lastRequest = new Date();
                VFSLibSettings.log(Level.CONFIG, "Unlocked client " + client.toString() + " (" + Integer.toHexString(client.hashCode()) + ") in pool");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private ManagedObject findManagedObject(ClientWrapper client) {
        Enumeration<String> keys = this.cachePool.keys();
        while (keys.hasMoreElements()) {
            String uri = keys.nextElement();
            Vector<ManagedObject> pool = this.cachePool.get(uri);
            for (ManagedObject managed : pool) {
                ClientWrapper nextclient = (ClientWrapper)managed.object;
                if (nextclient != client) continue;
                return managed;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean canRelease(Object id) {
        return true;
    }

    @Override
    public synchronized void release(Object id) {
        String url = id instanceof String ? (String)id : String.valueOf(id);
        Vector<ManagedObject> pool = this.cachePool.get(url);
        if (pool != null) {
            ClientWrapper client;
            Vector<ManagedObject> toremove = new Vector<ManagedObject>(0);
            for (ManagedObject managed : pool) {
                client = (ClientWrapper)managed.object;
                if (this.cacheLocked.contains(client)) continue;
                toremove.addElement(managed);
            }
            for (ManagedObject managed : toremove) {
                client = (ClientWrapper)managed.object;
                client.disconnectClient();
                pool.remove(managed);
                VFSLibSettings.log(Level.CONFIG, "Released object " + client.toString());
            }
            toremove.removeAllElements();
        }
    }

    @Override
    public synchronized void releaseForced() {
        Enumeration<String> en = this.cachePool.keys();
        while (en.hasMoreElements()) {
            String url = en.nextElement();
            this.release(url);
        }
    }

    @Override
    public synchronized void releaseByStrategy() {
        Enumeration<String> en = this.cachePool.keys();
        while (en.hasMoreElements()) {
            ClientWrapper client;
            String url = en.nextElement();
            Vector<ManagedObject> pool = this.cachePool.get(url);
            Vector<ManagedObject> toremove = new Vector<ManagedObject>(0);
            for (ManagedObject managed : pool) {
                client = (ClientWrapper)managed.object;
                if (client == null || this.cacheLocked.contains(client) || managed.strategy == null || !managed.strategy.canRelease(managed)) continue;
                toremove.addElement(managed);
            }
            for (ManagedObject managed : toremove) {
                client = (ClientWrapper)managed.object;
                client.disconnectClient();
                pool.remove(managed);
                VFSLibSettings.log(Level.CONFIG, "Released object " + client.toString() + " by strategy");
            }
            toremove.removeAllElements();
        }
    }

    @Override
    public synchronized void cleanup(Object id) {
    }

    @Override
    public synchronized boolean hasSharedInstance(Object id) {
        String url = id instanceof String ? (String)id : String.valueOf(id);
        Vector<ManagedObject> pool = this.cachePool.get(url);
        if (pool != null && !pool.isEmpty()) {
            for (ManagedObject managed : pool) {
                ClientWrapper client = (ClientWrapper)managed.object;
                if (this.cacheLocked.contains(client)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized ManagedObject[] getRegisteredObjects() {
        Vector<ManagedObject> sorter = new Vector<ManagedObject>(0);
        Enumeration<String> en = this.cachePool.keys();
        while (en.hasMoreElements()) {
            String url = en.nextElement();
            Vector<ManagedObject> pool = this.cachePool.get(url);
            for (ManagedObject managed : pool) {
                sorter.addElement(managed);
            }
        }
        Comparator<ManagedObject> comparator = new Comparator<ManagedObject>(){

            @Override
            public int compare(ManagedObject o1, ManagedObject o2) {
                String name1 = ((ClientWrapper)o1.object).getURLID();
                String name2 = ((ClientWrapper)o2.object).getURLID();
                return name1.compareTo(name2);
            }
        };
        Collections.sort(sorter, comparator);
        int size = sorter.size();
        ManagedObject[] array = new ManagedObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (ManagedObject)sorter.elementAt(i);
        }
        sorter.removeAllElements();
        return array;
    }

    @Override
    public synchronized Object set(Object id, Object obj) {
        return null;
    }

    public String debugPrint() {
        int i;
        Object[][] data = new Object[0][6];
        OrderedHashtable<String, StackTraceElement[]> cacheStacks = new OrderedHashtable<String, StackTraceElement[]>(0);
        StringBuilder builder = new StringBuilder(0);
        Enumeration<String> en = this.cachePool.keys();
        while (en.hasMoreElements()) {
            String url = en.nextElement();
            Vector<ManagedObject> pool = this.cachePool.get(url);
            for (i = 0; i < pool.size(); ++i) {
                ManagedObject managed = pool.elementAt(i);
                ClientWrapper client = (ClientWrapper)managed.object;
                boolean locked = this.cacheLocked.contains(client);
                String hashcode = Integer.toHexString(client.hashCode());
                if (locked) {
                    cacheStacks.put(hashcode, this.cacheLockedBy.get(client));
                }
                Object[] row = new Object[]{client.getURLID(), client.getClass().getName(), hashcode, String.valueOf(i + 1) + '/' + pool.size(), locked ? "locked" : "free"};
                data = (Object[][])JavaUtils.addToArray(data, row);
            }
        }
        if (data.length >= 1) {
            builder.append("\n\n" + StringUtils.assembleTable(data, 5, null));
            en = cacheStacks.keys();
            while (en.hasMoreElements()) {
                String hashcode = en.nextElement();
                StackTraceElement[] trace = (StackTraceElement[])cacheStacks.get(hashcode);
                builder.append("\nStack trace for client " + hashcode + ":\n\n");
                for (i = 0; i < trace.length; ++i) {
                    builder.append("\tat " + trace[i] + '\n');
                }
            }
        } else {
            builder.append("\n\nNo open VFS clients available\n");
        }
        cacheStacks.clear();
        return builder.toString();
    }

    static {
        STRATEGY = new TimeoutStrategy(10);
    }
}

