/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.lf.vfslib.VFSLib;
import com.lf.vfslib.gdrive.GDriveFileSystem;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;

public class GDriveFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    protected static GDriveFileSystemConfigBuilder sharedInstance;
    public static final String DISPLAY_NAME;
    public static final String ACCESS_TOKEN;
    public static final String USE_TRASH;
    protected VFSLib vfsLib = null;

    public GDriveFileSystemConfigBuilder() {
        this(null);
    }

    public GDriveFileSystemConfigBuilder(VFSLib vfslib) {
        super("gdrive.");
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
    }

    public static synchronized GDriveFileSystemConfigBuilder getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new GDriveFileSystemConfigBuilder();
        }
        return sharedInstance;
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return GDriveFileSystem.class;
    }

    public void setAccountDisplayName(FileSystemOptions options, String name) {
        super.setParam(options, DISPLAY_NAME, (Object)name);
    }

    public String getAccountDisplayName(FileSystemOptions options) {
        return (String)super.getParam(options, DISPLAY_NAME);
    }

    public void setAccessToken(FileSystemOptions options, String token) {
        super.setParam(options, ACCESS_TOKEN, (Object)token);
    }

    public String getAccessToken(FileSystemOptions options) {
        return (String)super.getParam(options, ACCESS_TOKEN);
    }

    public void setUseTrash(FileSystemOptions options, Boolean trash) {
        super.setParam(options, USE_TRASH, (Object)trash);
    }

    public Boolean getUseTrash(FileSystemOptions options) {
        return (Boolean)super.getParam(options, USE_TRASH);
    }

    static {
        DISPLAY_NAME = GDriveFileSystemConfigBuilder.class.getName() + ".DISPLAY_NAME";
        ACCESS_TOKEN = GDriveFileSystemConfigBuilder.class.getName() + ".ACCESS_TOKEN";
        USE_TRASH = GDriveFileSystemConfigBuilder.class.getName() + ".USE_TRASH";
    }
}

