/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.lf.vfslib.VFSLib;
import com.lf.vfslib.gdrive.GDriveClientWrapper;
import com.lf.vfslib.gdrive.GDriveFileObject;
import com.lf.vfslib.gdrive.GDriveFileProvider;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;

public class GDriveFileSystem
extends AbstractFileSystem
implements FileSystem {
    protected VFSLib vfsLib = null;
    protected GDriveFileProvider provider = null;

    protected GDriveFileSystem(GenericFileName rootName, FileSystemOptions options, VFSLib vfslib, GDriveFileProvider provider) {
        super((FileName)rootName, null, options);
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
    }

    protected GDriveClientWrapper getClient() throws IOException {
        return GDriveClientWrapper.getGDriveClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions(), this.vfsLib, this.provider);
    }

    protected void putClient(GDriveClientWrapper client) {
        GDriveClientWrapper.unlockGDriveClientWrapper(client);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(GDriveFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new GDriveFileObject(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public VFSLib getVFSLib() {
        return this.vfsLib;
    }

    public GDriveFileProvider getProvider() {
        return this.provider;
    }
}

