/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.gdrive;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.gdrive.GDriveFileSystemConfigBuilder;
import java.beans.Beans;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;

public class GDriveClientFactory {
    public GDriveClientFactory() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public static Drive createClient(GenericFileName root, FileSystemOptions options, String appname, GoogleAuthorizationCodeFlow authflow, VFSLib vfslib) throws IOException {
        GDriveFileSystemConfigBuilder builder = GDriveFileSystemConfigBuilder.getSharedInstance();
        String accesstoken = builder.getAccessToken(options);
        GoogleCredential credential = new GoogleCredential().setAccessToken(accesstoken);
        Drive.Builder drivebuilder = new Drive.Builder(authflow.getTransport(), authflow.getJsonFactory(), (HttpRequestInitializer)credential);
        if (appname != null) {
            drivebuilder.setApplicationName(appname);
        }
        Drive client = drivebuilder.build();
        return client;
    }
}

