/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.lf.vfslib.VFSLib;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.dropbox.DbxFileObject;
import com.lf.vfslib.dropbox.DbxFileProvider;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;

public class DbxFileSystem
extends AbstractFileSystem
implements FileSystem {
    protected VFSLib vfsLib = null;
    protected DbxFileProvider provider = null;

    protected DbxFileSystem(GenericFileName rootName, FileSystemOptions options, VFSLib vfslib, DbxFileProvider provider) {
        super((FileName)rootName, null, options);
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
    }

    protected DbxClientWrapper getClient() throws IOException {
        return DbxClientWrapper.getDbxClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions(), this.vfsLib, this.provider);
    }

    protected void putClient(DbxClientWrapper client) {
        DbxClientWrapper.unlockDbxClientWrapper(client);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DbxFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new DbxFileObject(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public VFSLib getVFSLib() {
        return this.vfsLib;
    }
}

