/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxRequestConfig;
import com.lf.commons.lang.JavaUtils;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientWrapper;
import com.lf.vfslib.dropbox.DbxFileNameParser;
import com.lf.vfslib.dropbox.DbxFileSystem;
import com.lf.vfslib.dropbox.DbxFileSystemConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;

public final class DbxFileProvider
extends AbstractOriginatingFileProvider {
    private DbxAppInfo appInfo = null;
    private DbxRequestConfig reqConfig = null;
    private VFSLib vfsLib = null;
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.RANDOM_ACCESS_READ, Capability.READ_CONTENT, Capability.RENAME, Capability.URI, Capability.WRITE_CONTENT));

    public DbxFileProvider() throws InstantiationException {
        throw new InstantiationException("Do not use this constructor!");
    }

    public DbxFileProvider(Object appinfo, Object reqconfig, VFSLib vfslib) {
        if (appinfo == null) {
            throw new NullPointerException();
        }
        if (!(appinfo instanceof DbxAppInfo)) {
            throw new IllegalArgumentException("Parameter appinfo must be of type DbxAppInfo");
        }
        if (reqconfig == null) {
            throw new NullPointerException();
        }
        if (!(reqconfig instanceof DbxRequestConfig)) {
            throw new IllegalArgumentException("Parameter reqconfig must be of type DbxRequestConfig");
        }
        if (vfslib == null) {
            throw new NullPointerException();
        }
        if (!JavaUtils.isMethodCalled(VFSLib.class, "addProviderDropbox")) {
            VFSLibSettings.logMessage("VFSLIB-0015", Level.SEVERE);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0015"));
        }
        try {
            Field field = VFSLib.class.getDeclaredField("licenseManager");
            field.setAccessible(true);
            Object obj = field.get(vfslib);
            Method method = obj.getClass().getDeclaredMethod("checkLicense", Object.class);
            method.setAccessible(true);
            method.invoke(obj, new Object[]{this});
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        this.appInfo = (DbxAppInfo)appinfo;
        this.reqConfig = (DbxRequestConfig)reqconfig;
        this.vfsLib = vfslib;
        this.setFileNameParser(DbxFileNameParser.getSharedInstance());
    }

    public DbxAppInfo getAppInfo() {
        return this.appInfo;
    }

    public DbxRequestConfig getRequestConfig() {
        return this.reqConfig;
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions options) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        DbxClientWrapper client = DbxClientWrapper.getDbxClientWrapper(rootName, options, this.vfsLib, this);
        DbxClientWrapper.unlockDbxClientWrapper(client);
        return new DbxFileSystem(rootName, options, this.vfsLib, this);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return DbxFileSystemConfigBuilder.getSharedInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

