/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.dropbox;

import com.dropbox.core.DbxClient;
import com.lf.commons.i18n.Localize;
import com.lf.vfslib.VFSLib;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxClientFactory;
import com.lf.vfslib.dropbox.DbxFileProvider;
import com.lf.vfslib.dropbox.DbxFileSystemConfigBuilder;
import com.lf.vfslib.net.ClientPool;
import com.lf.vfslib.net.ClientWrapper;
import java.beans.Beans;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;

public class DbxClientWrapper
implements ClientWrapper {
    protected GenericFileName root = null;
    protected FileSystemOptions fileSystemOptions = null;
    protected VFSLib vfsLib = null;
    protected DbxFileProvider provider = null;
    protected DbxClient dbxClient = null;

    @Localize(value={@Localize.Variable(name="CONNECT_ERROR", value="Could not connect to Dropbox server at %server%"), @Localize.Variable(name="UNKNOWN_MOD_TIME_ERROR", value="Last modification time not fetched"), @Localize.Variable(name="UNKNOWN_SIZE_ERROR", value="File size not fetched"), @Localize.Variable(name="READ_NOT_FILE_ERROR", value="Could not read from \"{0}\" because it is a not a file"), @Localize.Variable(name="RANDOM_ACCESS_INVALID_POSITION_ERROR", value="Invalid position: \"{0}\""), @Localize.Variable(name="RENAME_ERROR", value="Rename is only supported for files and folders")})
    public DbxClientWrapper() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    DbxClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, DbxFileProvider provider) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = options;
        this.vfsLib = vfslib != null ? vfslib : VFSLib.getSharedInstance();
        this.provider = provider;
        this.createClient();
    }

    protected void createClient() throws FileSystemException {
        try {
            this.dbxClient = DbxClientFactory.createClient(this.root, this.fileSystemOptions, this.provider.getRequestConfig(), this.vfsLib);
        }
        catch (Exception e) {
            String text = VFSLibSettings.getUserText(DbxClientWrapper.class, "CONNECT_ERROR");
            throw new FileSystemException(text.replaceAll("(%server%)", String.valueOf(this.root)), (Object)this.root, (Throwable)e);
        }
    }

    protected DbxClient getClient() {
        return this.dbxClient;
    }

    @Override
    public boolean disconnectClient() {
        return true;
    }

    @Override
    public String getURLID() {
        return this.toString();
    }

    public static DbxClientWrapper getDbxClientWrapper(GenericFileName root, FileSystemOptions options, VFSLib vfslib, DbxFileProvider provider) throws FileSystemException {
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        ClientPool pool = ClientPool.getSharedInstance();
        try {
            ClientWrapper recycled = pool.getFreeClient(DbxClientWrapper.getClientURLID(root, options, vfslib));
            if (recycled != null) {
                return (DbxClientWrapper)recycled;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DbxClientWrapper wrapper = new DbxClientWrapper(root, options, vfslib, provider);
        pool.addClient(wrapper);
        return wrapper;
    }

    public static void unlockDbxClientWrapper(DbxClientWrapper wrapper) {
        ClientPool.getSharedInstance().unlockClient(wrapper);
    }

    public String toString() {
        return DbxClientWrapper.getClientURLID(this.root, this.fileSystemOptions, this.vfsLib);
    }

    public static String getClientURLID(GenericFileName root, FileSystemOptions options, VFSLib vfslib) {
        DbxFileSystemConfigBuilder builder;
        String username;
        if (vfslib == null) {
            vfslib = VFSLib.getSharedInstance();
        }
        if ((username = (builder = DbxFileSystemConfigBuilder.getSharedInstance()).getAccountDisplayName(options)) == null) {
            username = "anonymous";
        }
        return vfslib.getSchemeDropbox() + "://" + username + '@' + root.getHostName();
    }
}

