/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib.core;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.I18NConfiguration;
import com.lf.commons.i18n.I18NUtils;
import com.lf.commons.i18n.Locale;
import com.lf.commons.lang.DeployProps;
import com.lf.commons.lang.StringUtils;
import com.lf.commons.msg.MessageCodes;
import com.lf.commons.msg.MessageFactory;
import com.lf.vfslib.net.VFSFileSystemManager;
import com.lf.vfslib.resource.ResourceLocator;
import java.beans.Beans;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.vfs2.FileObject;

public class VFSLibSettings {
    protected static VFSLibSettings sharedInstance;
    protected static VFSFileSystemManager vfsManagerNetwork;
    public static final String MSG_PREFIX = "VFSLIB";
    public static final String LOG_PREFIX = "[vfslib] ";
    private String i18nBase;
    private MessageCodes mcodes;
    private Logger logger;
    private Locale userLocale;
    private Locale logLocale;
    private I18NConfiguration i18nTexts;
    private I18NConfiguration englishTexts;
    private DeployProps version;

    public VFSLibSettings() {
        if (sharedInstance == null) {
            sharedInstance = this;
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        this.logLocale = new Locale("eng", "US");
        this.version = new DeployProps(ResourceLocator.class.getResourceAsStream("deploy.properties"));
        Logger nologger = Logger.getLogger(this.getClass().getName());
        nologger.setLevel(Level.OFF);
        this.logger = nologger;
        try {
            this.i18nBase = "com.lf.vfslib.core.i18n";
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mcodes = MessageFactory.createMessageCodes(MSG_PREFIX, this.i18nBase, this);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setUserLocale(new Locale("eng", "US"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized VFSFileSystemManager getManagerNetwork() {
        if (vfsManagerNetwork == null) {
            String[] ignored;
            vfsManagerNetwork = new VFSFileSystemManager();
            vfsManagerNetwork = new VFSFileSystemManager();
            for (String protocol : ignored = new String[]{"ram", "res", "tmp", "ear", "jar", "par", "sar", "war", "ejb3", "bz2", "gz", "tar", "tbz2", "tgz", "zip"}) {
                vfsManagerNetwork.removeOperationProvider(protocol);
            }
        }
        return vfsManagerNetwork;
    }

    public void check() {
        if (this.i18nBase != null) {
            this.logger.log(Level.CONFIG, "[vfslib] Internationalization path is present");
        } else {
            this.logger.log(Level.SEVERE, "VFSLIB-0005: Internationalization path could not be found");
        }
        String test = this.mcodes.getMessage("0000", this.logLocale, true);
        if (test != null) {
            this.logger.log(Level.CONFIG, "[vfslib] Message codes successfully loaded");
        } else {
            this.logger.log(Level.SEVERE, "VFSLIB-0002: Message codes not available");
        }
        if (this.version.getVersion() != null) {
            this.logger.log(Level.CONFIG, "[vfslib] Build properties successfully loaded");
        } else {
            this.logger.log(Level.SEVERE, "VFSLIB-0003: Build properties not available");
        }
    }

    public String getI18NBase() {
        return this.i18nBase;
    }

    public I18NConfiguration getI18NTexts() {
        return this.i18nTexts;
    }

    public synchronized I18NConfiguration getEnglishTexts() {
        if (this.englishTexts == null) {
            this.englishTexts = new I18NConfiguration();
            String target = "texts.conf";
            try {
                FileObject path = I18NUtils.getLocalizationVFS(this.i18nBase, this.logLocale, this);
                InputStream stream = path.getChild(target).getContent().getInputStream();
                this.englishTexts.read(stream);
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.englishTexts.getCache().isEmpty()) {
                this.logger.log(Level.WARNING, LOG_PREFIX + this.mcodes.getMessageReplace("0001", this.logLocale, true, "(%file%)", target));
            }
        }
        return this.englishTexts;
    }

    public static void localize(Object target, Class targetclazz) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        if (Beans.isDesignTime()) {
            return;
        }
        settings.getI18NTexts().localize(target, targetclazz, 1);
    }

    public static int extractLocalization(Object target) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        if (Beans.isDesignTime()) {
            return 0;
        }
        return settings.getI18NTexts().extractLocalization(target, 1);
    }

    public MessageCodes getMessageCodes() {
        return this.mcodes;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Invalid logger");
        }
        this.logger = logger;
        this.logger.log(Level.CONFIG, "[vfslib] Setting new logger with log level " + logger.getLevel());
        CommonsSettings.getSharedInstance().setLogger(logger);
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(Locale locale) throws IllegalArgumentException {
        Vector<Locale> locales = this.getSupportedLocales(true);
        if (!locales.contains(locale)) {
            throw new IllegalArgumentException("Unsupported locale " + locale);
        }
        locales = this.getSupportedLocales(false);
        if (!locales.contains(locale)) {
            for (Locale next : locales) {
                Vector<Locale> synonyms = Locale.getLocaleSynonyms(next);
                if (!synonyms.contains(locale)) continue;
                locale = next;
                break;
            }
        }
        if (locale.equals(this.userLocale)) {
            return;
        }
        if (this.i18nTexts == null) {
            this.i18nTexts = new I18NConfiguration();
        } else {
            this.i18nTexts.clear();
        }
        String target = "texts.conf";
        try {
            FileObject path = I18NUtils.getLocalizationVFS(this.i18nBase, locale, this);
            InputStream stream = path.getChild(target).getContent().getInputStream();
            this.i18nTexts.read(stream);
            stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.i18nTexts.getCache().isEmpty()) {
            this.logger.log(Level.WARNING, LOG_PREFIX + this.mcodes.getMessageReplace("0001", this.logLocale, true, "(%file%)", target));
            throw new IllegalArgumentException("No texts for locale " + locale);
        }
        this.logger.log(Level.CONFIG, "[vfslib] Loaded internationalized texts " + target);
        this.userLocale = locale;
        CommonsSettings.getSharedInstance().setUserLocale(this.userLocale);
    }

    public Vector<Locale> getSupportedLocales(boolean synonyms) {
        return I18NUtils.getSupportedLocales(this.i18nBase, this, synonyms);
    }

    public Locale getLogLocale() {
        return this.logLocale;
    }

    public DeployProps getDeployProps() {
        return this.version;
    }

    public static synchronized VFSLibSettings getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new VFSLibSettings();
        }
        return sharedInstance;
    }

    public static void log(Level level, String message) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        settings.getLogger().log(level, LOG_PREFIX + message);
    }

    public static void logMessage(Level level, String message) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        settings.getLogger().log(level, LOG_PREFIX + message);
    }

    public static void logMessage(String code, Level level) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        String message = settings.getMessageCodes().getMessage(code, settings.getLogLocale(), true);
        settings.getLogger().log(level, message);
    }

    public static void logMessage(String code, Level level, String regex, String replacement) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        String message = settings.getMessageCodes().getMessageReplace(code, settings.getLogLocale(), true, regex, replacement);
        settings.getLogger().log(level, message);
    }

    public static void logMessage(String code, Level level, String[] regex, String[] replacement) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        String message = settings.getMessageCodes().getMessageReplace(code, settings.getLogLocale(), true, regex, replacement);
        settings.getLogger().log(level, message);
    }

    public static String getUserMessage(String code) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        return settings.getMessageCodes().getMessage(code, settings.getUserLocale(), true);
    }

    public static String getEnglishMessage(String code) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        return settings.getMessageCodes().getMessage(code, settings.getLogLocale(), true);
    }

    public static String getUserMessage(String code, boolean prefix) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        return settings.getMessageCodes().getMessage(code, settings.getUserLocale(), prefix);
    }

    public static String getUserMessage(String code, String[] regex, String[] replacement, boolean prefix) {
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        return settings.getMessageCodes().getMessageReplace(code, settings.getUserLocale(), prefix, regex, replacement);
    }

    public static String getUserText(Class clazz, String variable) {
        String value = null;
        String fullvariable = null;
        try {
            VFSLibSettings settings = VFSLibSettings.getSharedInstance();
            fullvariable = clazz.getName() + ':' + variable;
            value = (String)settings.getI18NTexts().getObject(fullvariable, String.class);
        }
        catch (Exception e) {
            try {
                value = I18NUtils.getLocalizationValue(clazz, variable);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return value != null ? value : fullvariable;
    }

    public static String getEnglishText(Class clazz, String variable) {
        String value = null;
        String fullvariable = null;
        VFSLibSettings settings = VFSLibSettings.getSharedInstance();
        try {
            fullvariable = clazz.getName() + ':' + variable;
            value = (String)settings.getEnglishTexts().getObject(fullvariable, String.class);
        }
        catch (Exception e) {
            try {
                value = I18NUtils.getLocalizationValue(clazz, variable);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return value != null ? value : fullvariable;
    }

    public static String getEnglishText(Class clazz, String variable, String[] regex, String[] replacement) {
        try {
            String value = VFSLibSettings.getEnglishText(clazz, variable);
            if (value != null) {
                for (int i = 0; i < regex.length; ++i) {
                    value = StringUtils.safeReplaceAll(value, regex[i], replacement[i]);
                }
                return value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variable;
    }

    public static String getUserText(Class clazz, String variable, String[] regex, String[] replacement) {
        try {
            String value = VFSLibSettings.getUserText(clazz, variable);
            if (value != null) {
                for (int i = 0; i < regex.length; ++i) {
                    value = StringUtils.safeReplaceAll(value, regex[i], replacement[i]);
                }
                return value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variable;
    }

    public static void main(String[] arg) throws Exception {
    }
}

