/*
 * Decompiled with CFR 0.152.
 */
package com.lf.vfslib;

import com.lf.commons.crypto.PassphraseExtractor;
import com.lf.commons.i18n.Localize;
import com.lf.commons.io.Base64;
import com.lf.commons.io.IOUtils;
import com.lf.commons.lang.DateUtils;
import com.lf.commons.lang.DeployProps;
import com.lf.commons.lang.JavaUtils;
import com.lf.commons.lang.ReflectionUtils;
import com.lf.commons.lang.StringUtils;
import com.lf.vfslib.core.VFSLibSettings;
import com.lf.vfslib.dropbox.DbxFileProvider;
import com.lf.vfslib.gdrive.GDriveFileProvider;
import com.lf.vfslib.s3.S3FileProvider;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;

public final class VFSLib {
    private static VFSLib sharedInstance = null;
    private LicenseManager licenseManager = null;
    private Object hintObject = null;
    private String schemeDropbox = "dropbox";
    private String schemeGoogleDrive = "gdrive";
    private String schemeAmazonS3 = "s3";

    @Localize(value={@Localize.Variable(name="TRIAL_HINT_CLI_SINGLE", value="You are using an evaluation license (1 day left).\\nIf you find this software useful, please obtain a commercial license.\\nThis message disappears automatically after %timeout% seconds."), @Localize.Variable(name="TRIAL_HINT_CLI_MULTI", value="You are using an evaluation license (%days% days left).\\nIf you find this software useful, please obtain a commercial license.\\nThis message disappears automatically after %timeout% seconds."), @Localize.Variable(name="TRIAL_HINT_CONTINUE", value="Continue Evaluation"), @Localize.Variable(name="TRIAL_HINT_BUY", value="Buy License"), @Localize.Variable(name="TRIAL_HINT_EXIT", value="Exit"), @Localize.Variable(name="TRIAL_HINT_SINGLE", value="<html>You are using an evaluation license (1 day left). If you find<br>this software useful, please obtain a commercial license.<br>&nbsp;<p>How would you like to proceed?</html>"), @Localize.Variable(name="TRIAL_HINT_MULTI", value="<html>You are using an evaluation license (%days% days left). If you find<br>this software useful, please obtain a commercial license.<br>&nbsp;<p>How would you like to proceed?</html>"), @Localize.Variable(name="TRIAL_HINT_TITLE", value="VFSLib Evaluation License")})
    public VFSLib() {
    }

    public static synchronized VFSLib getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new VFSLib();
        }
        return sharedInstance;
    }

    public void setLicenseKey(String licensekey) {
        try {
            this.licenseManager = new LicenseManager();
            ByteArrayInputStream bistream = new ByteArrayInputStream(licensekey.getBytes("ISO-8859-1"));
            boolean success = this.licenseManager.loadLicense(bistream);
            bistream.close();
            if (success) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        VFSLibSettings.logMessage("VFSLIB-0006", Level.SEVERE);
        throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0006"));
    }

    public void setLicenseFile(File licensefile) {
        try {
            byte[] rawdata = IOUtils.readData(licensefile);
            String licensekey = new String(rawdata, "ISO-8859-1");
            this.licenseManager = new LicenseManager();
            ByteArrayInputStream bistream = new ByteArrayInputStream(licensekey.getBytes("ISO-8859-1"));
            boolean success = this.licenseManager.loadLicense(bistream);
            bistream.close();
            if (success) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        VFSLibSettings.logMessage("VFSLIB-0011", Level.SEVERE);
        throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0011"));
    }

    public void setLicenseURL(URL licenseurl) {
        try {
            byte[] rawdata = IOUtils.loadURLData(licenseurl);
            String licensekey = new String(rawdata, "ISO-8859-1");
            this.licenseManager = new LicenseManager();
            ByteArrayInputStream bistream = new ByteArrayInputStream(licensekey.getBytes("ISO-8859-1"));
            boolean success = this.licenseManager.loadLicense(bistream);
            bistream.close();
            if (success) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        VFSLibSettings.logMessage("VFSLIB-0012", Level.SEVERE);
        throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0012"));
    }

    public void setSchemeDropbox(String scheme) {
        if (scheme == null) {
            throw new NullPointerException();
        }
        if (scheme.trim().isEmpty()) {
            VFSLibSettings.logMessage("VFSLIB-0013", Level.WARNING);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0013"));
        }
        this.schemeDropbox = scheme;
    }

    public String getSchemeDropbox() {
        return this.schemeDropbox;
    }

    public DbxFileProvider addProviderDropbox(DefaultFileSystemManager manager, String appkey, String appsecret, String clientidentifier, String language) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (appkey == null) {
            throw new NullPointerException();
        }
        if (appsecret == null) {
            throw new NullPointerException();
        }
        if (clientidentifier == null) {
            throw new NullPointerException();
        }
        if (language == null) {
            throw new NullPointerException();
        }
        if (!VFSLib.checkLibsDropbox()) {
            return null;
        }
        boolean silent = true;
        Object appinfo = ReflectionUtils.newInstance(silent, "com.dropbox.core.DbxAppInfo", new Class[]{String.class, String.class}, appkey, appsecret);
        Object reqconfig = ReflectionUtils.newInstance(silent, "com.dropbox.core.DbxRequestConfig", new Class[]{String.class, String.class}, clientidentifier, language);
        return this.addProviderDropbox(manager, appinfo, reqconfig);
    }

    public DbxFileProvider addProviderDropbox(DefaultFileSystemManager manager, Object appinfo, Object reqconfig) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (appinfo == null) {
            throw new NullPointerException();
        }
        if (reqconfig == null) {
            throw new NullPointerException();
        }
        if (!VFSLib.checkLibsDropbox()) {
            return null;
        }
        boolean ok = false;
        DbxFileProvider provider = null;
        try {
            provider = new DbxFileProvider(appinfo, reqconfig, this);
            manager.addProvider(this.schemeDropbox, (FileProvider)provider);
            ok = true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0017", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0017"));
        }
        return ok ? provider : null;
    }

    private static boolean checkLibsDropbox() {
        try {
            Class.forName("com.dropbox.core.DbxSdkVersion");
            Class.forName("com.fasterxml.jackson.core.Version");
            return true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0016", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0016"));
            return false;
        }
    }

    public void setSchemeGoogleDrive(String scheme) {
        if (scheme == null) {
            throw new NullPointerException();
        }
        if (scheme.trim().isEmpty()) {
            VFSLibSettings.logMessage("VFSLIB-0018", Level.WARNING);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0018"));
        }
        this.schemeGoogleDrive = scheme;
    }

    public String getSchemeGoogleDrive() {
        return this.schemeGoogleDrive;
    }

    public GDriveFileProvider addProviderGoogleDrive(DefaultFileSystemManager manager, String clientid, String clientsecret, String appname, String redirecturi) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (clientid == null) {
            throw new NullPointerException();
        }
        if (clientsecret == null) {
            throw new NullPointerException();
        }
        if (appname == null) {
            throw new NullPointerException();
        }
        if (redirecturi == null) {
            throw new NullPointerException();
        }
        if (!VFSLib.checkLibsGoogleDrive()) {
            return null;
        }
        boolean silent = true;
        Object httptransport = ReflectionUtils.newInstance(silent, "com.google.api.client.http.javanet.NetHttpTransport", null, new Object[0]);
        Object jsonfactory = ReflectionUtils.newInstance(silent, "com.google.api.client.json.jackson2.JacksonFactory", null, new Object[0]);
        String[] array = new String[]{"https://www.googleapis.com/auth/drive"};
        Object builder = ReflectionUtils.newInstance("com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow$Builder", silent, new String[]{"com.google.api.client.http.HttpTransport", "com.google.api.client.json.JsonFactory", "java.lang.String", "java.lang.String", "java.util.Collection"}, httptransport, jsonfactory, clientid, clientsecret, Arrays.asList(array));
        ReflectionUtils.invoke(silent, builder, "setAccessType", new Class[]{String.class}, "online");
        ReflectionUtils.invoke(silent, builder, "setApprovalPrompt", new Class[]{String.class}, "auto");
        Object authflow = ReflectionUtils.invoke(silent, builder, "build", null, new Object[0]);
        return this.addProviderGoogleDrive(manager, authflow, appname, redirecturi);
    }

    public GDriveFileProvider addProviderGoogleDrive(DefaultFileSystemManager manager, Object authflow, String appname, String redirecturi) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (authflow == null) {
            throw new NullPointerException();
        }
        if (appname == null) {
            throw new NullPointerException();
        }
        if (redirecturi == null) {
            throw new NullPointerException();
        }
        if (!VFSLib.checkLibsGoogleDrive()) {
            return null;
        }
        boolean ok = false;
        GDriveFileProvider provider = null;
        try {
            provider = new GDriveFileProvider(authflow, appname, redirecturi, this);
            manager.addProvider(this.schemeGoogleDrive, (FileProvider)provider);
            ok = true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0019", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0019"));
        }
        return ok ? provider : null;
    }

    private static boolean checkLibsGoogleDrive() {
        try {
            Class.forName("com.google.api.client.googleapis.GoogleUtils");
            Class.forName("com.google.api.services.drive.Drive");
            Class.forName("com.google.api.client.http.EmptyContent");
            Class.forName("com.google.api.client.json.gson.GsonFactory");
            Class.forName("com.google.api.client.json.jackson2.JacksonFactory");
            Class.forName("com.google.api.client.extensions.jdo.JdoDataStoreFactory");
            Class.forName("com.google.api.client.auth.oauth.OAuthSigner");
            Class.forName("javax.annotation.CheckForNull");
            return true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0020", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0020"));
            return false;
        }
    }

    public void setSchemeAmazonS3(String scheme) {
        if (scheme == null) {
            throw new NullPointerException();
        }
        if (scheme.trim().isEmpty()) {
            VFSLibSettings.logMessage("VFSLIB-0022", Level.WARNING);
            throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0022"));
        }
        this.schemeAmazonS3 = scheme;
    }

    public String getSchemeAmazonS3() {
        return this.schemeAmazonS3;
    }

    public S3FileProvider addProviderAmazonS3(DefaultFileSystemManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        if (!VFSLib.checkLibsAmazonS3()) {
            return null;
        }
        boolean ok = false;
        S3FileProvider provider = null;
        try {
            provider = new S3FileProvider(this);
            manager.addProvider(this.schemeAmazonS3, (FileProvider)provider);
            ok = true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0023", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0023"));
        }
        return ok ? provider : null;
    }

    private static boolean checkLibsAmazonS3() {
        try {
            Class.forName("com.amazonaws.services.s3.iterable.S3Versions");
            return true;
        }
        catch (Exception e) {
            VFSLibSettings.logMessage("VFSLIB-0024", Level.WARNING);
            System.err.println(VFSLibSettings.getUserMessage("VFSLIB-0024"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTrialHint() {
        if (this.hintObject != null && this.hintObject instanceof StackTraceElement && JavaUtils.getMethod(false).endsWith(((StackTraceElement)this.hintObject).getMethodName() + '(' + ')')) {
            return;
        }
        int daysleft = this.licenseManager.calculateTrialDaysLeft();
        int timeout = 15;
        if (GraphicsEnvironment.isHeadless()) {
            String text = daysleft == 1 ? VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_CLI_SINGLE") : VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_CLI_MULTI");
            text = text.replaceAll("(%timeout%)", String.valueOf(timeout));
            System.out.println("");
            System.out.println(text);
            System.out.println("");
            try {
                Thread.sleep(timeout * 1000);
            }
            catch (Exception e) {
            }
            finally {
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                this.hintObject = trace[1];
            }
        } else {
            Object[] buttons = new String[]{VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_CONTINUE"), VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_BUY"), VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_EXIT")};
            ImageIcon icon = null;
            try {
                icon = new ImageIcon(VFSLib.class.getResource("resource/client_network_32.png"));
            }
            catch (Exception e) {
                // empty catch block
            }
            String text = daysleft == 1 ? VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_SINGLE") : VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_MULTI");
            Toolkit.getDefaultToolkit().beep();
            int retval = JOptionPane.showOptionDialog(null, text.replaceAll("(%days%)", String.valueOf(daysleft)), VFSLibSettings.getUserText(VFSLib.class, "TRIAL_HINT_TITLE"), -1, 1, icon, buttons, buttons[2]);
            if (retval == 1) {
                String shop = this.getDeployProps().getShopURL().toString();
                try {
                    JavaUtils.browse(shop);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (retval == 2 || retval == -1) {
                System.exit(0);
            }
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            this.hintObject = trace[1];
        }
    }

    private DeployProps getDeployProps() {
        return VFSLibSettings.getSharedInstance().getDeployProps();
    }

    private class LicenseProperties
    extends Properties {
    }

    private class LicenseManager {
        private static final String ID_EVALUATION_LICENSE = "Evaluation License";
        private static final String ID_SINGLE_USER_LICENSE = "Single-User License";
        private static final String ID_SINGLE_MACHINE_LICENSE = "Single-Machine License";
        private static final String ID_FLOATING_LICENSE = "Floating License";
        private static final String ID_SITE_LICENSE = "Site License";
        private static final String ID_DROPBOX_EDITION = "Dropbox Edition";
        private static final String ID_GOOGLE_DRIVE_EDITION = "Google Drive Edition";
        private static final String ID_AMAZON_S3_EDITION = "Amazon S3 Edition";
        private static final String ID_ENTERPRISE_EDITION = "Enterprise Edition";
        private LicenseProperties config = null;
        private Properties license = null;

        public LicenseManager() {
            this.config = new LicenseProperties();
            String data = "eJxdVrcK7VqSzR+8f3jDhKKRd8EN5M2R9xKdyB157/X1c2g6mgqroGAvU3v97//8U475VDRj9Udxz\nX9RFE7/C/7HH5tfs/xH2PJ0Lre///r7r23+M9hSw4rKy76XwzI8HGdmOLVfXqYkWw3ntQCJ0LmmaE\nnalW35h0lyIhaCmDygdTzp29H4+otZXjtHHqqJxPhBdGIQFNKcQR6UrxMBM1Uq16bBn6NTaWoAp7d\n8ZVkrRrSi8JAQunnaHuCIBFXJHwxdrrkZos+TIbhYYbiaxcN02FB3+Sd+UJqcszrRUc7FVai+ipf2\nJVh91bve9oxvwLCZo+qKz4PoJwsLhvea9h2O7g0misvh/h6e0aS20Pcg4cuIcdCFTToyC6V5HVVUY\nQQ3K9PHVkf0bxrWTB81pTayEbKa3VeuFzAVkNExhfG0vuw5ZHtc4nOepP6L89v4DnKm7S3gg52dta\nCz9TCLU3iwbxUS9oMVJ8jBKTGSpK9bS8xKtHjBhy0DXoqj4xhRJ1kSQkfLcWahIXjd8D7xjsdNN1e\nFqGSt8q3gPsrRCnavs5FpxM2FHtwOuh//fWgN/rjGKxqW9Lk/b7vO/WoWENM4dQa7+YEUriC09TnW\nSSzEjSiM25S+q+wN6MdWnjd//GAzzmmh3RJ+Vtcjhpm6HWn4yK71gNfJXqourvYTdInnSX2j8MJhN\nDimiEafj0mfNwxVDMmb/WZa9N9ex25J2L9JiA9JeL/aYJyZRyiJbXuCrTCq7XN+q8sWE6rMf0rJmC\nvW2KtSmWuSRFtROHtiWTZmmYrhJFtguKqzT+DtgRrpsxq4u4pLmTlWChjEvSdWev4zAfUJSELVsi3\nFTDryrkD3RqMpXxIznbMUB9WImeXWHrau/1f/NsdwFCXf8XHfgcY8G7WGOkns8YIAGGTzVyUvnOnK\nnRT+tip9GQSgt9QQuJ1ZJlK2QWDye8kJjK+9WlXyjsPNDJCq68OP8LidPyd0gUoxtPOG6614bqqvt\np4ezzuuSSb+wfdElV2OQIP89umb0qD9pc125cWp/a7jXRaY5ea81p/cnrEgi4mkzGTUROWzsdP43h\nsdcJxoPX8/yyTTJC2rPV209FHr8qlw4/hwuz1GvloqkLXhBdwhj9nEGBFke4vepfyjW1Qbq+pCuJI\ndw0Q7lW+s8cn3LEMZe39GTG+DmDfMjSJ7LEolDZnvswQw7iOimk+TOJZoOCG936Q35HYjRBZLSBak\np7vw6A6XlTTc87jAFjXOVlz2AAJi0DEYCjIOt74hR37mFXTk6VPmUEUDdoQqYeP4KWv5cPB4GBM1X\nvm4zVfcwzS5R02fxFZsxAChpZwilJ4TGp/0+Dl/QFzivtRjRFZIczyYSDFC9TMHPVxMV7U4GBQXzw\na9YLrArzbAO7dypUu/uoif9/CBIIyF/kCa8AEsjmwOh5Ws6Dt/hOzKvtKY2dO+WgPIOB8fBpW6Tvd\nRMyvptBvRm0itYczFP37WQoAvJFUPFE0OnY9c31sClKCnOHHjbPJO6MYERl+4wCffdE1d5snfwuEo\ni3wtr8a0oWtDKzTm+b0wpuCq4GwUzX6sbs9/uC5nyTL9D8HxI8hAutrTF9buJnXK3KpDyzR2Zsmos\nF2zbXXOx0KOYMfaBjVpjPeLEAWd2ojpVtdD0cKKjtpxAk5n9oJ5q/NQaW6lQLKtqf9ymO4qIjhxN3\nDDYfeJ4uIZw1XaGI2REqqua7ctFGW/8AKwRANulPTLZF4sVxJ/P9i+Uac7n1Jx+BHC37zdDU8b25u\nvuBkC1BEu6bqltf08mOGQ9t6F21dz8oqMy9asgEdwt099P/fJ/h4ClkqNt/VgQqvGgM/0QvVx2HQp\nIIpwxwspAJ4ZeOYsOCas7rVCSuxUvzAE1fHpmdhSXsUrIEv+JbkMREWDYEn6DtVUjqLyhui6ETpBY\ngWOYTqR6f9zGzjpuv7f3aHmuOIy1nVUW1VO4IATMpfmzcgpAMWhrygwgy164Wb3lXaG16ffo4E7r/\nZ2bDpd//4rX//8vskQtPQWk8P0WOe5mRMj2iutCwKEk0s/XQQDVfNszVlfv6mhD3udV6PFqYwwdNT\nqbcRNp/PYwBbG4un7gyXU3QnbeNrRXnydd+Iu5CZGQ2AXAXvM40zGK1V0GU9v0ZfCtIYnnu4Q6knA\nVh3nC0DzUGZWRqw/4fuT53fRoFZrCyte9D22Mb/zt7Ixgn4ozSyNiSkbR5iMDZ1Hf2QgWVcK4cpCC\nEvXEyjcaXKeIxn0mK/2zCC3n2ny6J4/Z1OUibqFq18W2S8TqtQaylaI+bYsBQhxvCZihOZ6whsf68\ngIP+cu0oVz5QK6fK+A7ZILQSl5kryuhfz2FFyHVIiUggi+6JuVILiS3Ex5qktvdWqmaRkZ6X0Y9GW\nCzUNf5xfNbEjfhe/K+aeSf4x12eh2Bl+iZLfc9vlRtp08q2O8G7EdPsXGYm0lsx13lL4S1Sh3UB9R\nDMqBHGrpNUIMcDSBBbxYXX6z7Au+u+/lHf8RoWa0FkzG4SVzU9ZkthZ9J2JiJtwNczVl2HY+pyz2E\n/EkjsBN2qyteOC88xu/lmpaoS1aBlmgqmiYlq1gz5f5WJ4ahcWElVMn2mX6wZO637vd0vQhmtwfrY\nqQN4Wq5Txx5wsOCxaB3117nGZF4BzKQmyotRTB7fM92EaP025M8pn4dLLUnvu6RmB/NfTzyL64ErX\nXiFEXFYUBybQ0g0HBZVydK0KyU25/vhYPs9VCwS4vzolSkz6sI5BGLk4YoF+hndJ+WiYrXxhKTKXZ\nDbT4C5SVTNPImIwMfE7IF0fHHaq4Z+c5aa7ZY9NTinUIwNyDSBwfvKQRCAzv0w/mDM+1Xv9whNQTG\n1zWpZY+yCLfyGmox03e2mrTF0U55qRLat99XRKjHx/S16W0RL9A6O+0NJiQVsU02xxfS8qgh+RHq7\nfNZQ4ak2P4vUc10KzGxuxPyzkQr4lFlAlNXwIqsvR27Qc2tIGugv0CFVqocKnTb0xCYoVUETmr7sC\nnOOXRKH8M32pmjnEA++n+WjtJLMi7hSrBaikEOK94oXH+dWBAFnJ75R/XcYCoOOZkj1uyg7a2bBs6\nVNYSpF4+LLMgM/jEtjwgNNfaIDtuUD2+BF59bJmIh8SbBS1yvufPoDxHhVc7CXyBUCgHQxtnSdqmS\nmlwcZVvFROLBo7hDd9g4giny9pACtQPirBjl9jZEJADfA57gAb6er/hbrir4Bixk2XNXJ+7nZJ0Af\nFy0HJKFF7zz0oMrPfDeW/Ub42eSA5fuMESpuIcT/v9yiBjdScIqjBnHqjWcnopDWj0ibKXsa9J3GN\n++WYnebWa94p+HmGBgBZuV1vGB8LNB3sNKsIMe62zURISUEORaD50avDD1Ef89upwTPxlXTV7KTS1\n//3n33/+/uv/AF2CXN0=";
            try {
                String[] lines = StringUtils.extractLines(data, "ISO-8859-1");
                String textdata = StringUtils.concatArray(lines, "");
                byte[] rawdata = Base64.decodeBase64(textdata.getBytes("ISO-8859-1"));
                InflaterInputStream istream = new InflaterInputStream(new ByteArrayInputStream(rawdata));
                this.config.load(istream);
                istream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean isEvaluationLicense() {
            String type = this.getLicenseType();
            return type != null && type.equals(ID_EVALUATION_LICENSE);
        }

        private String getLicenseType() {
            if (this.license == null) {
                return null;
            }
            try {
                String type = this.license.getProperty("/license/info/type", "");
                if (type.equals(ID_EVALUATION_LICENSE) || type.equals(ID_SINGLE_USER_LICENSE) || type.equals(ID_SINGLE_MACHINE_LICENSE) || type.equals(ID_FLOATING_LICENSE) || type.equals(ID_SITE_LICENSE)) {
                    return type;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        private boolean isDropboxEdition() {
            String type = this.getEdition();
            return type != null && type.equals(ID_DROPBOX_EDITION);
        }

        private boolean isGoogleDriveEdition() {
            String type = this.getEdition();
            return type != null && type.equals(ID_GOOGLE_DRIVE_EDITION);
        }

        private boolean isAmazonS3Edition() {
            String type = this.getEdition();
            return type != null && type.equals(ID_AMAZON_S3_EDITION);
        }

        private boolean isEnterpriseEdition() {
            String type = this.getEdition();
            return type != null && type.equals(ID_ENTERPRISE_EDITION);
        }

        private String getEdition() {
            if (this.license == null) {
                return null;
            }
            try {
                String type = this.license.getProperty("/license/info/product/type", "");
                if (type.equals(ID_DROPBOX_EDITION) || type.equals(ID_GOOGLE_DRIVE_EDITION) || type.equals(ID_AMAZON_S3_EDITION) || type.equals(ID_ENTERPRISE_EDITION)) {
                    return type;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        private int calculateTrialDaysLeft() {
            if (!this.isEvaluationLicense()) {
                return -1;
            }
            try {
                String datestring = this.license.getProperty("/license/info/valid_until", "");
                Date until = new SimpleDateFormat("yyyy-MM-dd").parse(datestring);
                return DateUtils.calculateDays(new Date(), until);
            }
            catch (Throwable throwable) {
                return -1;
            }
        }

        private String isLicenseValid() {
            if (this.license == null) {
                return "VFSLIB-0006";
            }
            try {
                Date date;
                Date today = DateUtils.normalizeDateMidnight(new Date());
                Date build = VFSLib.this.getDeployProps().getDate();
                build = DateUtils.normalizeDateMidnight(build);
                String appid = VFSLib.this.getDeployProps().getID();
                String valid_from = this.license.getProperty("/license/info/valid_from", "");
                String valid_until = this.license.getProperty("/license/info/valid_until", "");
                String updates_until = this.license.getProperty("/license/info/updates_until", "");
                String updates_regex = this.license.getProperty("/license/info/updates_regex", "");
                if (valid_from.length() > 0) {
                    date = new SimpleDateFormat("yyyy-MM-dd").parse(valid_from);
                    if (today.getTime() < date.getTime()) {
                        VFSLibSettings.logMessage("VFSLIB-0007", Level.SEVERE);
                        return "VFSLIB-0007";
                    }
                }
                if (valid_until.length() > 0) {
                    date = new SimpleDateFormat("yyyy-MM-dd").parse(valid_until);
                    if (today.getTime() > date.getTime()) {
                        VFSLibSettings.logMessage("VFSLIB-0008", Level.SEVERE);
                        return "VFSLIB-0008";
                    }
                }
                if (updates_until.length() > 0) {
                    date = new SimpleDateFormat("yyyy-MM-dd").parse(updates_until);
                    if (build.getTime() > date.getTime()) {
                        VFSLibSettings.logMessage("VFSLIB-0009", Level.SEVERE);
                        return "VFSLIB-0009";
                    }
                }
                if (updates_regex.length() > 0 && appid.replaceAll(updates_regex, "").length() > 0) {
                    VFSLibSettings.logMessage("VFSLIB-0010", Level.SEVERE);
                    return "VFSLIB-0010";
                }
                return "OK";
            }
            catch (Throwable throwable) {
                return "VFSLIB-0014";
            }
        }

        private synchronized boolean loadLicense(InputStream istream) {
            boolean success = false;
            byte[] buffer = new byte[1024];
            String encoding = "ISO-8859-1";
            try {
                int len;
                byte[] keyrandom = Base64.decodeBase64(this.config.getProperty("cr").getBytes("ISO-8859-1"));
                ByteArrayInputStream bistream = new ByteArrayInputStream(keyrandom);
                String passphrase = PassphraseExtractor.extractHex(bistream, 64);
                String aeskey = passphrase.substring(0, 16);
                bistream.close();
                MessageDigest md = MessageDigest.getInstance("SHA-512");
                md.update(Base64.decodeBase64(this.config.getProperty("sp").getBytes("ISO-8859-1")));
                byte[] digest = md.digest();
                String keysignature = "";
                for (int i = 0; i < digest.length; ++i) {
                    keysignature = keysignature + JavaUtils.convertToHex(digest[i], false);
                }
                ByteArrayOutputStream bostream = new ByteArrayOutputStream();
                while ((len = istream.read(buffer)) != -1) {
                    bostream.write(buffer, 0, len);
                }
                bostream.flush();
                bostream.close();
                byte[] encrypted = bostream.toByteArray();
                byte[] decrypted = null;
                byte[] decoded = Base64.decodeBase64(encrypted);
                ZipInputStream zistream = new ZipInputStream(new ByteArrayInputStream(decoded));
                ZipEntry entry = zistream.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".txt")) {
                        try {
                            Cipher aes = Cipher.getInstance("AES");
                            SecretKeySpec key = new SecretKeySpec(aeskey.getBytes(encoding), "AES");
                            aes.init(2, key);
                            byte[] zipentrydata = IOUtils.readData(zistream);
                            String[] lines = StringUtils.extractLines(new String(zipentrydata, encoding), encoding);
                            String textdata = StringUtils.concatArray(lines, "");
                            encrypted = Base64.decodeBase64(textdata.getBytes(encoding));
                            decrypted = aes.doFinal(encrypted);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (decrypted != null) break;
                    entry = zistream.getNextEntry();
                }
                String signature = null;
                if (decrypted != null && decrypted.length >= 1) {
                    this.license = this.getProperties(decrypted);
                    signature = this.license.getProperty("/license/signature");
                }
                if (this.license != null && signature != null) {
                    String licensetext = new String(decrypted, "UTF-8");
                    licensetext = licensetext.replaceAll(signature, keysignature);
                    String calculated = this.calculateSignature(licensetext.getBytes("UTF-8"));
                    success = calculated.equals(signature);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (!success) {
                this.license = null;
            }
            return success;
        }

        private Properties getProperties(byte[] data) {
            Properties props = new Properties();
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                ByteArrayInputStream bistream = new ByteArrayInputStream(data);
                XMLEventReader eventReader = inputFactory.createXMLEventReader(bistream);
                String path = "";
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isStartElement()) {
                        StartElement startElement = event.asStartElement();
                        path = path + '/' + startElement.getName().getLocalPart();
                        String value = "";
                        XMLEvent lookahead = eventReader.peek();
                        while (lookahead != null && lookahead.isCharacters()) {
                            value = value + lookahead.asCharacters().getData();
                            eventReader.next();
                            lookahead = eventReader.peek();
                        }
                        if (StringUtils.matchesRegex(value.trim(), "([\n\r]+)")) continue;
                        props.setProperty(path, value);
                        continue;
                    }
                    if (!event.isEndElement()) continue;
                    path = path.substring(0, path.lastIndexOf(47));
                }
                ((InputStream)bistream).close();
                return props;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private String calculateSignature(byte[] data) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-512");
                md.update(data);
                byte[] digest = md.digest();
                String signature = "";
                for (int i = 0; i < digest.length; ++i) {
                    signature = signature + JavaUtils.convertToHex(digest[i], false);
                }
                return signature;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private void checkLicense(Object obj) {
            String result = this.isLicenseValid();
            if (!result.equals("OK")) {
                VFSLibSettings.logMessage(result, Level.SEVERE);
                throw new IllegalArgumentException(VFSLibSettings.getUserMessage(result));
            }
            if (obj instanceof DbxFileProvider) {
                if (!this.isDropboxEdition() && !this.isEnterpriseEdition()) {
                    VFSLibSettings.logMessage("VFSLIB-0015", Level.SEVERE);
                    throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0015"));
                }
            } else if (obj instanceof GDriveFileProvider) {
                if (!this.isGoogleDriveEdition() && !this.isEnterpriseEdition()) {
                    VFSLibSettings.logMessage("VFSLIB-0021", Level.SEVERE);
                    throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0021"));
                }
            } else if (obj instanceof S3FileProvider) {
                if (!this.isAmazonS3Edition() && !this.isEnterpriseEdition()) {
                    VFSLibSettings.logMessage("VFSLIB-0025", Level.SEVERE);
                    throw new IllegalArgumentException(VFSLibSettings.getUserMessage("VFSLIB-0025"));
                }
            } else {
                VFSLibSettings.logMessage(result, Level.SEVERE);
                throw new IllegalArgumentException(VFSLibSettings.getUserMessage(result));
            }
            if (this.isEvaluationLicense()) {
                VFSLib.this.showTrialHint();
            }
        }
    }
}

