/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.msg;

import com.lf.commons.i18n.I18NUtils;
import com.lf.commons.i18n.Locale;
import com.lf.commons.msg.MessageCache;
import java.beans.Beans;
import java.io.File;
import java.util.Hashtable;
import org.apache.commons.vfs2.FileObject;

public class MessageCodes {
    protected Hashtable<Locale, MessageCache> cacheMessagesByLocale = null;
    protected String id = null;
    protected String base = null;
    protected Object loader = null;
    protected File directory = null;

    public MessageCodes() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public MessageCodes(String id, String base, Object loader) {
        if (id == null || base == null || loader == null) {
            throw new NullPointerException();
        }
        this.cacheMessagesByLocale = new Hashtable(0);
        this.id = id;
        this.base = base;
        this.loader = loader;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheMessagesByLocale != null) {
            this.cacheMessagesByLocale.clear();
        }
    }

    public synchronized String getMessage(String code, Locale locale, boolean prefix) {
        MessageCache mcache = this.cacheMessagesByLocale.get(locale);
        try {
            return mcache.getMessage(code, prefix);
        }
        catch (Exception e) {
            FileObject path;
            if (code == null) {
                throw new IllegalArgumentException();
            }
            if (mcache == null && (path = I18NUtils.getLocalizationVFS(this.base, locale, this.loader)) != null) {
                mcache = new MessageCache(locale, this.id, path);
                this.cacheMessagesByLocale.put(locale, mcache);
                return mcache.getMessage(code, prefix);
            }
            return null;
        }
    }

    public synchronized String getMessageReplace(String code, Locale locale, boolean prefix, String regex, String replacement) {
        String result;
        block4: {
            result = null;
            MessageCache mcache = this.cacheMessagesByLocale.get(locale);
            try {
                result = mcache.getMessage(code, prefix);
            }
            catch (Exception e) {
                FileObject path;
                if (code == null) {
                    throw new IllegalArgumentException();
                }
                if (mcache != null || (path = I18NUtils.getLocalizationVFS(this.base, locale, this.loader)) == null) break block4;
                mcache = new MessageCache(locale, this.id, path);
                this.cacheMessagesByLocale.put(locale, mcache);
                result = mcache.getMessage(code, prefix);
            }
        }
        if (result != null) {
            return result.replaceAll(regex, replacement);
        }
        return null;
    }

    public synchronized String getMessageReplace(String code, Locale locale, boolean prefix, String[] regex, String[] replacement) {
        String result;
        block5: {
            result = null;
            MessageCache mcache = this.cacheMessagesByLocale.get(locale);
            try {
                result = mcache.getMessage(code, prefix);
            }
            catch (Exception e) {
                FileObject path;
                if (code == null) {
                    throw new IllegalArgumentException();
                }
                if (mcache != null || (path = I18NUtils.getLocalizationVFS(this.base, locale, this.loader)) == null) break block5;
                mcache = new MessageCache(locale, this.id, path);
                this.cacheMessagesByLocale.put(locale, mcache);
                result = mcache.getMessage(code, prefix);
            }
        }
        if (result != null) {
            for (int i = 0; i < regex.length; ++i) {
                result = result.replaceAll(regex[i], replacement[i]);
            }
            return result;
        }
        return null;
    }
}

