/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang.strategy;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Localize;
import com.lf.commons.lang.ManagedObject;
import com.lf.commons.lang.ReleaseStrategy;
import java.beans.Beans;
import java.util.Date;

public class TimeoutStrategy
implements ReleaseStrategy {
    protected int timeout = 0;

    @Localize(value={@Localize.Variable(name="TIMEOUT", value="Timeout (%minutes% min)")})
    public TimeoutStrategy() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public TimeoutStrategy(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean canRelease(ManagedObject object) {
        if (object.lastRequest != null) {
            Date now = new Date();
            return now.getTime() - object.lastRequest.getTime() >= (long)(this.timeout * 60000);
        }
        return false;
    }

    public String toString() {
        String text = CommonsSettings.getUserText(TimeoutStrategy.class, "TIMEOUT");
        return text.replaceAll("(%minutes%)", String.valueOf(this.timeout));
    }
}

