/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import com.lf.commons.lang.JavaUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class StringUtils {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] UNALLOWED_CLI = new char[]{'<', '>', '\"', '\'', '$', '!', '{', '}', '\t', '\n', '\r', '\f'};

    public static String concatArray(String[] parts, String separator) {
        return StringUtils.concatArray(parts, 0, separator);
    }

    public static String concatArray(String[] parts, int offset, String separator) {
        StringBuilder result = new StringBuilder(0);
        for (int i = offset; i < parts.length; ++i) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(parts[i]);
        }
        return result.toString();
    }

    public static String safeReplaceAll(String text, String regex, String replacement) {
        replacement = replacement.replaceAll("[\\$]", "%DOLLAR%");
        text = text.replaceAll(regex, replacement);
        return text.replaceAll("(%DOLLAR%)", "\\$");
    }

    public static String safeReplaceFirst(String text, String regex, String replacement) {
        replacement = replacement.replaceAll("[\\$]", "%DOLLAR%");
        text = text.replaceFirst(regex, replacement);
        return text.replaceAll("(%DOLLAR%)", "\\$");
    }

    public static boolean matchesRegex(String value, String pattern) {
        try {
            return StringUtils.safeReplaceFirst(value, pattern, "").length() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String assembleTable(Object[][] array, int spaces, Character framechar) {
        int i;
        String text;
        if (array.length == 0) {
            return "";
        }
        if (array[0].length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(0);
        String linefeed = System.getProperty("line.separator");
        int[] colwidths = new int[array[0].length];
        for (int i2 = 0; i2 < colwidths.length; ++i2) {
            colwidths[i2] = 0;
        }
        for (int row = 0; row < array.length; ++row) {
            for (int col = 0; col < array[row].length; ++col) {
                text = String.valueOf(array[row][col]);
                colwidths[col] = Math.max(colwidths[col], text.length());
            }
        }
        int totalcols = 0;
        for (i = 0; i < colwidths.length; ++i) {
            totalcols += colwidths[i];
        }
        totalcols += (array[0].length - 1) * spaces;
        if (framechar != null) {
            for (i = 0; i < totalcols; ++i) {
                builder.append(framechar);
            }
            builder.append(linefeed);
        }
        for (int row = 0; row < array.length; ++row) {
            for (int col = 0; col < array[row].length; ++col) {
                int i3;
                text = String.valueOf(array[row][col]);
                builder.append(text);
                for (i3 = text.length(); i3 < colwidths[col]; ++i3) {
                    builder.append(' ');
                }
                if (col + 1 >= array[row].length) continue;
                for (i3 = 0; i3 < spaces; ++i3) {
                    builder.append(' ');
                }
            }
            builder.append(linefeed);
        }
        if (framechar != null) {
            for (i = 0; i < totalcols; ++i) {
                builder.append(framechar);
            }
            builder.append(linefeed);
        }
        return builder.toString();
    }

    public static String[] extractLines(String string, String encoding) {
        String[] result = new String[]{};
        try {
            String line;
            ByteArrayInputStream istream = encoding != null ? new ByteArrayInputStream(string.getBytes(encoding)) : new ByteArrayInputStream(string.getBytes());
            InputStreamReader isreader = new InputStreamReader((InputStream)istream, encoding);
            LineNumberReader reader = new LineNumberReader(isreader);
            while ((line = reader.readLine()) != null) {
                result = (String[])JavaUtils.addToArray(result, line);
            }
            reader.close();
            istream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

