/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import com.lf.commons.lang.JavaUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static boolean isSubclassing(Class clazz, Class superclass) {
        try {
            Class next = clazz;
            while (next.getSuperclass() != null) {
                if (next.getSuperclass().equals(superclass)) {
                    return true;
                }
                next = next.getSuperclass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Object getDeclaredField(Object target, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(name);
        field.setAccessible(true);
        return field.get(target);
    }

    public static Object getDeclaredField(Object target, Class clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null) {
            clazz = target.getClass();
        }
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(target);
    }

    public static Object newInstance(boolean silent, String classname, Class[] paramtypes, Object ... initargs) {
        try {
            if (paramtypes == null) {
                return Class.forName(classname).newInstance();
            }
            return Class.forName(classname).getConstructor(paramtypes).newInstance(initargs);
        }
        catch (Throwable e) {
            if (!silent) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Object newInstance(String classname, boolean silent, String[] paramtypes, Object ... initargs) {
        try {
            if (paramtypes == null) {
                return Class.forName(classname).newInstance();
            }
            Class[] classes = new Class[]{};
            for (String next : paramtypes) {
                classes = (Class[])JavaUtils.addToArray(classes, Class.forName(next));
            }
            return Class.forName(classname).getConstructor(classes).newInstance(initargs);
        }
        catch (Throwable e) {
            if (!silent) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Object invoke(boolean silent, Object target, String methodname, Class[] paramtypes, Object ... args) {
        try {
            if (paramtypes == null) {
                Method method = target.getClass().getMethod(methodname, new Class[0]);
                return method.invoke(target, new Object[0]);
            }
            Method method = target.getClass().getMethod(methodname, paramtypes);
            return method.invoke(target, args);
        }
        catch (Throwable e) {
            if (!silent) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

