/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import com.lf.commons.lang.OrderedSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class OrderedHashtable<K, V>
extends Hashtable<K, V> {
    protected Vector<K> ordercache = new Vector(0);

    public OrderedHashtable() {
    }

    public OrderedHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.ordercache.removeAllElements();
    }

    @Override
    public void clear() {
        this.ordercache.removeAllElements();
        super.clear();
    }

    @Override
    public Enumeration<V> elements() {
        return new Enumeration<V>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < OrderedHashtable.this.ordercache.size();
            }

            @Override
            public V nextElement() {
                if (this.hasMoreElements()) {
                    Object result = OrderedHashtable.super.get(OrderedHashtable.this.ordercache.elementAt(this.index));
                    ++this.index;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        OrderedSet<Map.Entry<K, V>> oset = new OrderedSet<Map.Entry<K, V>>();
        for (K next : this.ordercache) {
            oset.addElement(new AbstractMap.SimpleEntry(next, super.get(next)));
        }
        return oset;
    }

    @Override
    public Enumeration<K> keys() {
        return new Enumeration<K>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < OrderedHashtable.this.ordercache.size();
            }

            @Override
            public K nextElement() {
                if (this.hasMoreElements()) {
                    Object result = OrderedHashtable.this.ordercache.elementAt(this.index);
                    ++this.index;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        OrderedSet<K> oset = new OrderedSet<K>();
        for (K next : this.ordercache) {
            oset.addElement(next);
        }
        return oset;
    }

    @Override
    public V put(K key, V value) {
        if (this.ordercache.contains(key)) {
            this.ordercache.removeElement(key);
        }
        this.ordercache.addElement(key);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            if (this.ordercache.contains(e.getKey())) {
                this.ordercache.removeElement(e.getKey());
            }
            this.ordercache.addElement(e.getKey());
        }
        super.putAll(t);
    }

    @Override
    public V remove(Object key) {
        this.ordercache.remove(key);
        return super.remove(key);
    }

    @Override
    public Collection<V> values() {
        Vector coll = new Vector(this.ordercache.size());
        for (K next : this.ordercache) {
            coll.addElement(super.get(next));
        }
        return coll;
    }
}

