/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.lang;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.lang.FactoryManager;
import com.lf.commons.lang.ManagedObject;
import com.lf.commons.lang.strategy.NeverStrategy;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

public abstract class ManagedFactory {
    protected Hashtable<Object, ManagedObject> cacheObjectByID;

    public ManagedFactory() {
        FactoryManager.registerFactory(this);
        this.cacheObjectByID = new Hashtable(0);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheObjectByID != null) {
            this.cacheObjectByID.clear();
        }
    }

    public abstract Object request(Object var1);

    public abstract boolean canRelease(Object var1);

    public abstract void cleanup(Object var1);

    public synchronized boolean hasSharedInstance(Object id) {
        ManagedObject managed = this.cacheObjectByID.get(id);
        return managed != null && managed.object != null;
    }

    public synchronized void releaseForced() {
        Enumeration<Object> en = this.cacheObjectByID.keys();
        while (en.hasMoreElements()) {
            Object id = en.nextElement();
            ManagedObject item = this.cacheObjectByID.get(id);
            if (item.object == null || !this.canRelease(id) || item.strategy == null || item.strategy instanceof NeverStrategy) continue;
            this.cleanup(id);
            item.object = null;
            item.lastRequest = null;
            item.requestCount = 0;
            ++item.releaseCount;
        }
    }

    public synchronized void releaseByStrategy() {
        Enumeration<Object> en = this.cacheObjectByID.keys();
        while (en.hasMoreElements()) {
            Object id = en.nextElement();
            ManagedObject item = this.cacheObjectByID.get(id);
            if (item.object == null || !this.canRelease(id) || item.strategy == null || !item.strategy.canRelease(item)) continue;
            String name = item.object != null ? item.object.getClass().getName() : "?";
            String strategy = item.strategy != null ? item.strategy.toString() : "?";
            CommonsSettings.logMessage(Level.CONFIG, "Released object " + name + " (strategy " + strategy + ')');
            this.cleanup(id);
            item.object = null;
            item.lastRequest = null;
            item.requestCount = 0;
            ++item.releaseCount;
        }
    }

    public synchronized ManagedObject[] getRegisteredObjects() {
        Vector<Object> sorter = new Vector<Object>(0);
        Enumeration<Object> en = this.cacheObjectByID.keys();
        while (en.hasMoreElements()) {
            sorter.addElement(en.nextElement());
        }
        Collections.sort(sorter);
        int size = sorter.size();
        ManagedObject[] array = new ManagedObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.cacheObjectByID.get(sorter.elementAt(i));
        }
        sorter.removeAllElements();
        return array;
    }

    public synchronized void release(Object id) {
        ManagedObject item = this.cacheObjectByID.get(id);
        if (item.object == null) {
            return;
        }
        if (!this.canRelease(id)) {
            return;
        }
        this.cleanup(id);
        item.object = null;
        item.lastRequest = null;
        item.requestCount = 0;
        ++item.releaseCount;
    }

    public synchronized Object set(Object id, Object obj) {
        ManagedObject item = this.cacheObjectByID.get(id);
        if (item == null) {
            return null;
        }
        Object oldobj = item.object;
        item.object = obj;
        return oldobj;
    }
}

