/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.commons.vfs2.FileObject;

public class IOUtils {
    public static byte[] loadURLData(URL location) throws IOException {
        byte[] buffer = null;
        Vector<Integer> victor = new Vector<Integer>(0);
        if (location != null) {
            int intvalue = 0;
            InputStream stream = location.openStream();
            while (intvalue != -1) {
                intvalue = stream.read();
                if (intvalue == -1) continue;
                victor.addElement(intvalue);
            }
            stream.close();
            int size = victor.size();
            buffer = new byte[size];
            for (int i = 0; i < size; ++i) {
                Integer intelement = (Integer)victor.elementAt(i);
                buffer[i] = intelement.byteValue();
            }
            victor.removeAllElements();
        }
        return buffer;
    }

    public static byte[] readData(FileObject vfsfile) throws IOException {
        InputStream istream = vfsfile.getContent().getInputStream();
        byte[] data = IOUtils.readData(istream);
        istream.close();
        return data;
    }

    public static byte[] readData(File file) throws IOException {
        FileInputStream istream = new FileInputStream(file);
        byte[] data = IOUtils.readData(istream);
        ((InputStream)istream).close();
        return data;
    }

    public static byte[] readData(InputStream istream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        while ((len = istream.read(buffer)) != -1) {
            ostream.write(buffer, 0, len);
        }
        ostream.flush();
        return ostream.toByteArray();
    }
}

