/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.io;

import com.lf.commons.io.TypeProvider;
import com.lf.commons.lang.ManagedFactory;
import com.lf.commons.lang.ManagedObject;
import com.lf.commons.lang.strategy.TimeoutStrategy;
import com.lf.vfslib.net.VFSURI;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.vfs2.FileObject;

public class FileTypeFactory
extends ManagedFactory
implements TypeProvider {
    protected File tempdir;
    protected boolean caching;

    public File getTemporaryDirectory() {
        return this.tempdir;
    }

    @Override
    public synchronized Object request(Object id) {
        ManagedObject managed;
        block8: {
            ManagedObject managedObject = managed = this.caching ? this.cacheObjectByID.get(id) : null;
            if (managed != null && managed.object != null) {
                managed.lastRequest = new Date();
                ++managed.requestCount;
                return managed.object;
            }
            try {
                File tempfile = null;
                File checkfile = null;
                File file = new File(String.valueOf(id));
                if (file.exists()) {
                    checkfile = file;
                } else {
                    VFSURI vfsuri = new VFSURI(String.valueOf(id));
                    checkfile = tempfile = this.createTemporaryFile(vfsuri);
                }
                Hashtable<String, Object> values = new Hashtable<String, Object>(0);
                values.put("KEY_DISPLAY_NAME", FileSystemView.getFileSystemView().getSystemDisplayName(checkfile));
                values.put("KEY_TYPE_DESCRIPTION", FileSystemView.getFileSystemView().getSystemTypeDescription(checkfile));
                values.put("KEY_ICON", FileSystemView.getFileSystemView().getSystemIcon(checkfile));
                if (tempfile != null && !tempfile.delete()) {
                    tempfile.deleteOnExit();
                }
                if (!this.caching) {
                    return values;
                }
                String clazz = values.getClass().getName();
                managed = new ManagedObject(null, id, clazz, new TimeoutStrategy(10), null, 0, 0);
                managed.object = values;
                this.cacheObjectByID.put(id, managed);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (managed == null) break block8;
                managed.object = null;
            }
        }
        if (managed != null && managed.object != null) {
            managed.lastRequest = new Date();
            managed.requestCount = 1;
            return managed.object;
        }
        return null;
    }

    @Override
    public synchronized boolean canRelease(Object id) {
        return true;
    }

    @Override
    public synchronized void cleanup(Object id) {
    }

    protected File createTemporaryFile(Object resource) {
        if (this.tempdir == null) {
            return null;
        }
        try {
            String basename;
            if (resource instanceof File) {
                basename = ((File)resource).getName();
            } else if (resource instanceof FileObject) {
                basename = ((FileObject)resource).getName().getBaseName();
            } else {
                VFSURI vfsuri = (VFSURI)resource;
                basename = new File(vfsuri.getPath()).getName();
            }
            File tempfile = new File(this.tempdir.toString() + File.separator + basename);
            if (tempfile.exists() || tempfile.createNewFile()) {
                return tempfile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Hashtable<String, Object> getInfo(Object resource) {
        return (Hashtable)this.request(String.valueOf(resource));
    }
}

