/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import java.beans.Beans;
import java.util.StringTokenizer;
import java.util.Vector;

public class Locale
implements Comparable<Locale> {
    protected static final String[] iso3166_1 = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW"};
    protected static final String[] iso639_1 = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "io", "is", "it", "iu", "ja", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    protected static final String[] iso639_2 = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "afa", "afh", "afr", "aka", "akk", "alb", "ale", "alg", "amh", "ang", "apa", "ara", "arc", "arg", "arm", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "ave", "awa", "aym", "aze", "bad", "bai", "bak", "bal", "bam", "ban", "baq", "bas", "bat", "bej", "bel", "bem", "ben", "ber", "bho", "bih", "bik", "bin", "bis", "bla", "bnt", "bod", "bos", "bra", "bre", "btk", "bua", "bug", "bul", "bur", "byn", "cad", "cai", "car", "cat", "cau", "ceb", "cel", "ces", "cha", "chb", "che", "chg", "chi", "chk", "chm", "chn", "cho", "chp", "chr", "chu", "chv", "chy", "cmc", "cop", "cor", "cos", "cpe", "cpf", "cpp", "cre", "crh", "crp", "csb", "cus", "cym", "cze", "dak", "dan", "dar", "day", "del", "den", "deu", "dgr", "din", "div", "doi", "dra", "dsb", "dua", "dum", "dut", "dyu", "dzo", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "est", "eus", "ewe", "ewo", "fan", "fao", "fas", "fat", "fij", "fil", "fin", "fiu", "fon", "fra", "fre", "frm", "fro", "fry", "ful", "fur", "gaa", "gay", "gba", "gem", "geo", "ger", "gez", "gil", "gla", "gle", "glg", "glv", "gmh", "goh", "gon", "gor", "got", "grb", "grc", "gre", "grn", "guj", "gwi", "hai", "hat", "hau", "haw", "heb", "her", "hil", "him", "hin", "hit", "hmn", "hmo", "hrv", "hsb", "hun", "hup", "hye", "iba", "ibo", "ice", "ido", "iii", "ijo", "iku", "ile", "ilo", "ina", "inc", "ind", "ine", "inh", "ipk", "ira", "iro", "isl", "ita", "jav", "jbo", "jpn", "jpr", "jrb", "kaa", "kab", "kac", "kal", "kam", "kan", "kar", "kas", "kat", "kau", "kaw", "kaz", "kbd", "kha", "khi", "khm", "kho", "kik", "kin", "kir", "kmb", "kok", "kom", "kon", "kor", "kos", "kpe", "krc", "kro", "kru", "kua", "kum", "kur", "kut", "lad", "lah", "lam", "lao", "lat", "lav", "lez", "lim", "lin", "lit", "lol", "loz", "ltz", "lua", "lub", "lug", "lui", "lun", "luo", "lus", "mac", "mad", "mag", "mah", "mai", "mak", "mal", "man", "mao", "map", "mar", "mas", "may", "mdf", "mdr", "men", "mga", "mic", "min", "mis", "mkd", "mkh", "mlg", "mlt", "mnc", "mni", "mno", "moh", "mol", "mon", "mos", "mri", "msa", "mul", "mun", "mus", "mwl", "mwr", "mya", "myn", "myv", "nah", "nai", "nap", "nau", "nav", "nbl", "nde", "ndo", "nds", "nep", "new", "nia", "nic", "niu", "nld", "nno", "nob", "nog", "non", "nor", "nso", "nub", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "ori", "orm", "osa", "oss", "ota", "oto", "paa", "pag", "pal", "pam", "pan", "pap", "pau", "peo", "per", "phi", "phn", "pli", "pol", "pon", "por", "pra", "pro", "pus", "que", "raj", "rap", "rar", "roa", "roh", "rom", "ron", "rum", "run", "rus", "sad", "sag", "sah", "sai", "sal", "sam", "san", "sas", "sat", "scc", "scn", "sco", "scr", "sel", "sem", "sga", "sgn", "shn", "sid", "sin", "sio", "sit", "sla", "slk", "slo", "slv", "sma", "sme", "smi", "smj", "smn", "smo", "sms", "sna", "snd", "snk", "sog", "som", "son", "sot", "spa", "sqi", "srd", "srp", "srr", "ssa", "ssw", "suk", "sun", "sus", "sux", "swa", "swe", "syr", "tah", "tai", "tam", "tat", "tel", "tem", "ter", "tet", "tgk", "tgl", "tha", "tib", "tig", "tir", "tiv", "tkl", "tlh", "tli", "tmh", "tog", "ton", "tpi", "tsi", "tsn", "tso", "tuk", "tum", "tup", "tur", "tut", "tvl", "twi", "tyv", "udm", "uga", "uig", "ukr", "umb", "und", "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wak", "wal", "war", "was", "wel", "wen", "wln", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "zap", "zen", "zha", "zho", "znd", "zul", "zun"};
    protected static final String[][] iso639_syns = new String[][]{{"aar", "aa"}, {"abk", "ab"}, {"afr", "af"}, {"aka", "ak"}, {"alb", "sqi", "sq"}, {"amh", "am"}, {"ara", "ar"}, {"arg", "an"}, {"arm", "hye", "hy"}, {"asm", "as"}, {"ava", "av"}, {"ave", "ae"}, {"aym", "ay"}, {"aze", "az"}, {"bak", "ba"}, {"bam", "bm"}, {"baq", "eus", "eu"}, {"bel", "be"}, {"ben", "bn"}, {"bih", "bh"}, {"bis", "bi"}, {"bos", "bs"}, {"bre", "br"}, {"bul", "bg"}, {"bur", "mya", "my"}, {"cat", "ca"}, {"cha", "ch"}, {"che", "ce"}, {"chi", "zho", "zh"}, {"chu", "cu"}, {"chv", "cv"}, {"cor", "kw"}, {"cos", "co"}, {"cre", "cr"}, {"cze", "ces", "cs"}, {"dan", "da"}, {"div", "dv"}, {"dut", "nld", "nl"}, {"dzo", "dz"}, {"eng", "en"}, {"epo", "eo"}, {"est", "et"}, {"ewe", "ee"}, {"fao", "fo"}, {"fij", "fj"}, {"fin", "fi"}, {"fre", "fra", "fr"}, {"fry", "fy"}, {"ful", "ff"}, {"geo", "kat", "ka"}, {"ger", "deu", "de"}, {"gla", "gd"}, {"gle", "ga"}, {"glg", "gl"}, {"glv", "gv"}, {"gre", "ell", "el"}, {"grn", "gn"}, {"guj", "gu"}, {"hat", "ht"}, {"hau", "ha"}, {"heb", "he"}, {"her", "hz"}, {"hin", "hi"}, {"hmo", "ho"}, {"hun", "hu"}, {"ibo", "ig"}, {"ice", "isl", "is"}, {"ido", "io"}, {"iii", "ii"}, {"iku", "iu"}, {"ile", "ie"}, {"ina", "ia"}, {"ind", "id"}, {"ipk", "ik"}, {"ita", "it"}, {"jav", "jv"}, {"jpn", "ja"}, {"kal", "kl"}, {"kan", "kn"}, {"kas", "ks"}, {"kau", "kr"}, {"kaz", "kk"}, {"khm", "km"}, {"kik", "ki"}, {"kin", "rw"}, {"kir", "ky"}, {"kom", "kv"}, {"kon", "kg"}, {"kor", "ko"}, {"kua", "kj"}, {"kur", "ku"}, {"lao", "lo"}, {"lat", "la"}, {"lav", "lv"}, {"lim", "li"}, {"lin", "ln"}, {"lit", "lt"}, {"ltz", "lb"}, {"lub", "lu"}, {"lug", "lg"}, {"mac", "mkd", "mk"}, {"mah", "mh"}, {"mal", "ml"}, {"mao", "mri", "mi"}, {"mar", "mr"}, {"may", "msa", "ms"}, {"mlg", "mg"}, {"mlt", "mt"}, {"mol", "mo"}, {"mon", "mn"}, {"nau", "na"}, {"nav", "nv"}, {"nbl", "nr"}, {"nde", "nd"}, {"ndo", "ng"}, {"nep", "ne"}, {"nno", "nn"}, {"nob", "nb"}, {"nor", "no"}, {"nya", "ny"}, {"oci", "oc"}, {"oji", "oj"}, {"ori", "or"}, {"orm", "om"}, {"oss", "os"}, {"pan", "pa"}, {"per", "fas", "fa"}, {"pli", "pi"}, {"pol", "pl"}, {"por", "pt"}, {"pus", "ps"}, {"que", "qu"}, {"roh", "rm"}, {"rum", "ron", "ro"}, {"run", "rn"}, {"rus", "ru"}, {"sag", "sg"}, {"san", "sa"}, {"scc", "srp", "sr"}, {"scr", "hrv", "hr"}, {"sin", "si"}, {"slo", "slk", "sk"}, {"slv", "sl"}, {"sme", "se"}, {"smo", "sm"}, {"sna", "sn"}, {"snd", "sd"}, {"som", "so"}, {"sot", "st"}, {"spa", "es"}, {"srd", "sc"}, {"ssw", "ss"}, {"sun", "su"}, {"swa", "sw"}, {"swe", "sv"}, {"tah", "ty"}, {"tam", "ta"}, {"tat", "tt"}, {"tel", "te"}, {"tgk", "tg"}, {"tgl", "tl"}, {"tha", "th"}, {"tib", "bod", "bo"}, {"tir", "ti"}, {"ton", "to"}, {"tsn", "tn"}, {"tso", "ts"}, {"tuk", "tk"}, {"tur", "tr"}, {"twi", "tw"}, {"uig", "ug"}, {"ukr", "uk"}, {"urd", "ur"}, {"uzb", "uz"}, {"ven", "ve"}, {"vie", "vi"}, {"vol", "vo"}, {"wel", "cym", "cy"}, {"wln", "wa"}, {"wol", "wo"}, {"xho", "xh"}, {"yid", "yi"}, {"yor", "yo"}, {"zha", "za"}, {"zul", "zu"}};
    protected String language;
    protected String country;
    protected String variant;

    public Locale() throws InstantiationException {
        if (!Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    public Locale(String language) {
        if (language == null) {
            throw new NullPointerException();
        }
        if (language.length() == 2) {
            if (!this.containsISO639_1(language)) {
                throw new IllegalArgumentException();
            }
        } else if (language.length() == 3) {
            if (!this.containsISO639_2(language)) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.language = language;
    }

    public Locale(String language, String country) {
        if (language == null || country == null) {
            throw new NullPointerException();
        }
        if (language.length() == 2) {
            if (!this.containsISO639_1(language)) {
                throw new IllegalArgumentException();
            }
        } else if (language.length() == 3) {
            if (!this.containsISO639_2(language)) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.language = language;
        if (!this.containsISO3166_1(country)) {
            throw new IllegalArgumentException();
        }
        this.country = country;
    }

    public Locale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        if (language.length() == 2) {
            if (!this.containsISO639_1(language)) {
                throw new IllegalArgumentException();
            }
        } else if (language.length() == 3) {
            if (!this.containsISO639_2(language)) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.language = language;
        if (!this.containsISO3166_1(country)) {
            throw new IllegalArgumentException();
        }
        this.country = country;
        this.variant = variant;
    }

    private boolean containsISO3166_1(String code) {
        for (int i = 0; i < iso3166_1.length; ++i) {
            if (!iso3166_1[i].equals(code)) continue;
            return true;
        }
        return false;
    }

    private boolean containsISO639_1(String code) {
        for (int i = 0; i < iso639_1.length; ++i) {
            if (!iso639_1[i].equals(code)) continue;
            return true;
        }
        return false;
    }

    private boolean containsISO639_2(String code) {
        for (int i = 0; i < iso639_2.length; ++i) {
            if (!iso639_2[i].equals(code)) continue;
            return true;
        }
        return false;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof Locale && this.toString().equals(obj.toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return Locale.toString(this.language, this.country, this.variant);
    }

    public static String toString(String language, String country, String variant) {
        StringBuilder builder = new StringBuilder(5);
        builder.append(language);
        if (country != null) {
            builder.append('_');
            builder.append(country);
            if (variant != null) {
                builder.append('_');
                builder.append(variant);
            }
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Locale other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static Locale parseLocale(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        String language = null;
        String country = null;
        String variant = null;
        StringTokenizer tokenizer = new StringTokenizer(id, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        while (tokenizer.hasMoreTokens()) {
            if (variant == null) {
                variant = tokenizer.nextToken();
                continue;
            }
            variant = variant + '_' + tokenizer.nextToken();
        }
        try {
            if (language != null && country == null && variant == null) {
                return new Locale(language);
            }
            if (language != null && country != null && variant == null) {
                return new Locale(language, country);
            }
            if (language != null && country != null && variant != null) {
                return new Locale(language, country, variant);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    public static Vector<Locale> getLocaleSynonyms(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        Vector<Locale> result = new Vector<Locale>(1);
        try {
            String[] synonyms = null;
            String langcode = locale.getLanguage();
            for (int i = 0; i < iso639_syns.length; ++i) {
                String[] test = iso639_syns[i];
                for (int s = 0; s < test.length; ++s) {
                    if (!test[s].equals(langcode)) continue;
                    synonyms = test;
                    break;
                }
                if (synonyms != null) break;
            }
            if (synonyms != null) {
                for (int s = 0; s < synonyms.length; ++s) {
                    if (synonyms[s].equals(langcode)) continue;
                    String synlocale = locale.toString().replaceFirst("(^" + langcode + ')', synonyms[s]);
                    result.addElement(Locale.parseLocale(synlocale));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

